/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.Base64;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.DigitalSignatureFailure;
import io.intino.alexandria.schemas.DigitalSignatureSuccess;
import io.intino.alexandria.ui.displays.components.AbstractBaseDigitalSignature;
import io.intino.alexandria.ui.displays.events.SignErrorEvent;
import io.intino.alexandria.ui.displays.events.SignErrorListener;
import io.intino.alexandria.ui.displays.events.SignEvent;
import io.intino.alexandria.ui.displays.events.SignListener;
import io.intino.alexandria.ui.displays.notifiers.BaseDigitalSignatureNotifier;
import io.intino.icod.core.SignatureInfo;
import java.nio.charset.StandardCharsets;

public abstract class BaseDigitalSignature<DN extends BaseDigitalSignatureNotifier, B extends Box>
extends AbstractBaseDigitalSignature<DN, B> {
    private SignListener signListener;
    private SignErrorListener errorListener;
    private String text;
    public boolean readonly = false;

    public BaseDigitalSignature(B box) {
        super(box);
    }

    @Override
    public void didMount() {
        super.didMount();
        ((BaseDigitalSignatureNotifier)this.notifier).refreshReadonly(this.readonly);
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.text != null) {
            ((BaseDigitalSignatureNotifier)this.notifier).text(this.text);
        }
    }

    public BaseDigitalSignature<DN, B> readonly(boolean readonly) {
        this.readonly = readonly;
        ((BaseDigitalSignatureNotifier)this.notifier).refreshReadonly(readonly);
        return this;
    }

    public void text(String content) {
        this.text = Base64.encode((byte[])content.getBytes(StandardCharsets.UTF_8));
        ((BaseDigitalSignatureNotifier)this.notifier).text(this.text);
    }

    public void sign() {
        ((BaseDigitalSignatureNotifier)this.notifier).sign();
    }

    public void success(DigitalSignatureSuccess success) {
        this.signListener.accept(new SignEvent(this, success.signature(), success.certificate(), this.info(success.signature())));
    }

    public void failure(DigitalSignatureFailure failure) {
        this.errorListener.accept(new SignErrorEvent(this, failure.code(), failure.message()));
    }

    public BaseDigitalSignature<DN, B> onSign(SignListener listener) {
        this.signListener = listener;
        return this;
    }

    public BaseDigitalSignature<DN, B> onError(SignErrorListener listener) {
        this.errorListener = listener;
        return this;
    }

    protected abstract SignatureInfo info(String var1);
}

