/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria;

import io.intino.alexandria.I18n;
import io.intino.alexandria.UiFrameworkBox;
import io.intino.alexandria.UiFrameworkConfiguration;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.http.AlexandriaSparkBuilder;
import io.intino.alexandria.logger.Formatter;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.AlexandriaUiBox;
import io.intino.alexandria.ui.Soul;
import io.intino.alexandria.ui.UISpark;
import io.intino.alexandria.ui.UiElementsService;
import io.intino.alexandria.ui.displays.RouteDispatcher;
import io.intino.alexandria.ui.services.AuthService;
import io.intino.alexandria.ui.services.TranslatorService;
import io.intino.alexandria.ui.services.push.PushService;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;

public abstract class AbstractBox
extends AlexandriaUiBox {
    protected UiFrameworkConfiguration configuration;
    protected Map<String, Soul> uiSouls = new HashMap<String, Soul>();
    private List<AlexandriaUiBox.SoulsClosed> soulsClosedListeners = new ArrayList<AlexandriaUiBox.SoulsClosed>();
    private AuthService authService;
    private PushService pushService;

    public AbstractBox(String[] args) {
        this(new UiFrameworkConfiguration(args));
    }

    public AbstractBox(UiFrameworkConfiguration configuration) {
        this.configuration = configuration;
        this.initJavaLogger();
    }

    public UiFrameworkConfiguration configuration() {
        return this.configuration;
    }

    public Box put(Object o) {
        return this;
    }

    public abstract void beforeStart();

    public Box start() {
        if (this.owner != null) {
            this.owner.beforeStart();
        }
        this.beforeStart();
        if (this.owner != null) {
            this.owner.startServices();
        }
        this.startServices();
        if (this.owner != null) {
            this.owner.afterStart();
        }
        this.afterStart();
        return this;
    }

    public abstract void afterStart();

    public abstract void beforeStop();

    public void stop() {
        if (this.owner != null) {
            this.owner.beforeStop();
        }
        this.beforeStop();
        if (this.owner != null) {
            this.owner.stopServices();
        }
        this.stopServices();
        if (this.owner != null) {
            this.owner.afterStop();
        }
        this.afterStop();
    }

    public void stopServices() {
        AlexandriaSparkBuilder.instance().stop();
    }

    public abstract void afterStop();

    public void startServices() {
        this.initUI();
        this.initConnector();
        this.initRestServices();
        this.initSoapServices();
        this.initJmxServices();
        this.initDatalake();
        this.initTerminal();
        this.initMessagingServices();
        this.initSentinels();
        this.initSlackBots();
        this.initWorkflow();
        this.initAgenda();
    }

    public PushService pushService() {
        return this.pushService;
    }

    public List<Soul> souls() {
        return new ArrayList<Soul>(this.uiSouls.values());
    }

    public Optional<Soul> soul(String clientId) {
        return Optional.ofNullable(this.uiSouls.get(clientId));
    }

    @Override
    public void registerSoul(String clientId, Soul soul) {
        this.uiSouls.put(clientId, soul);
    }

    @Override
    public void unRegisterSoul(String clientId) {
        this.uiSouls.remove(clientId);
        if (this.uiSouls.size() <= 0) {
            this.notifySoulsClosed();
        }
    }

    public void onSoulsClosed(AlexandriaUiBox.SoulsClosed listener) {
        this.soulsClosedListeners.add(listener);
    }

    private void notifySoulsClosed() {
        this.soulsClosedListeners.forEach(l -> l.accept());
    }

    protected abstract AuthService authService(URL var1);

    public void setupUi() {
        if ("9000".isEmpty()) {
            return;
        }
        this.authService = null;
        AlexandriaSparkBuilder.setup((int)Integer.parseInt("9000"), (String)"www/");
        AlexandriaSparkBuilder.setUI((boolean)true);
        AlexandriaSparkBuilder.addParameters((Object[])new Object[]{this.authService});
        this.pushService = new PushService();
        UISpark sparkInstance = (UISpark)AlexandriaSparkBuilder.instance();
        UiElementsService.init(sparkInstance, (UiFrameworkBox)this, this.pushService, new RouteDispatcher());
        UiElementsService.initDisplays(sparkInstance, this.pushService);
    }

    private void initRestServices() {
    }

    private void initSoapServices() {
    }

    private void initMessagingServices() {
    }

    private void initJmxServices() {
    }

    private void initSlackBots() {
    }

    private void initUI() {
        this.setupUi();
        this.initTranslatorService();
        UISpark sparkInstance = (UISpark)AlexandriaSparkBuilder.instance();
        sparkInstance.start();
        Logger.info((String)"UI UiElements: started at port 9000!");
    }

    private void initTranslatorService() {
        this.translatorService = new TranslatorService();
        this.translatorService.addAll(I18n.dictionaries());
        this.translatorService.addAll(I18n.dictionaries());
    }

    private void initDatalake() {
    }

    private void initConnector() {
    }

    private void initTerminal() {
    }

    private void initSentinels() {
    }

    private void initWorkflow() {
    }

    private void initAgenda() {
    }

    protected void initJavaLogger() {
        java.util.logging.Logger Logger2 = java.util.logging.Logger.getGlobal();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.INFO);
        handler.setFormatter((java.util.logging.Formatter)new Formatter());
        Logger2.setUseParentHandlers(false);
        Logger2.addHandler(handler);
        io.intino.alexandria.logger4j.Logger.init();
    }

    protected URL url(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

