/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.model.dynamictable;

import io.intino.alexandria.ui.model.dynamictable.Cell;
import java.util.ArrayList;
import java.util.List;

public class Row {
    private String label;
    private String description;
    private List<Cell> cells = new ArrayList<Cell>();

    public Row(String label) {
        this.label = label;
    }

    public Row(String label, String description) {
        this(label);
        this.description = description;
    }

    public String label() {
        return this.label;
    }

    public Row label(String label) {
        this.label = label;
        return this;
    }

    public String description() {
        return this.description;
    }

    public Row description(String description) {
        this.description = description;
        return this;
    }

    public Cell cell(String name) {
        return this.cells.stream().filter(c -> c.name().equals(name)).findFirst().orElse(null);
    }

    public List<Cell> cells() {
        return this.cells;
    }

    public Row add(String column, double value) {
        this.add(new Cell(column, value));
        return this;
    }

    public Row add(Cell cell) {
        this.cells.add(cell);
        return this;
    }
}

