/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.LayerToolbar;
import io.intino.alexandria.schemas.LayerToolbarButton;
import io.intino.alexandria.ui.Soul;
import io.intino.alexandria.ui.displays.Component;
import io.intino.alexandria.ui.displays.components.AbstractLayer;
import io.intino.alexandria.ui.displays.components.OpenLayer;
import io.intino.alexandria.ui.displays.events.Event;
import io.intino.alexandria.ui.displays.events.Listener;
import io.intino.alexandria.ui.displays.notifiers.LayerNotifier;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;

public class Layer<DN extends LayerNotifier, B extends Box>
extends AbstractLayer<B> {
    private Component<?, ?> template;
    private String title;
    private List<Listener> openListeners = new ArrayList<Listener>();
    private List<Listener> closeListeners = new ArrayList<Listener>();
    private OpenLayer<?, ?> homeAction;
    private Consumer<Layer> previousListener;
    private Function<Layer, Boolean> canPreviousResolver;
    private Consumer<Layer> nextListener;
    private Function<Layer, Boolean> canNextResolver;

    public Layer(B box) {
        super(box);
    }

    @Override
    public void didMount() {
        super.didMount();
        this.refresh();
    }

    public Layer<DN, B> bindTo(OpenLayer<?, ?> actionable) {
        this.homeAction = actionable;
        return this;
    }

    public Layer<DN, B> onPrevious(Consumer<Layer> listener, Function<Layer, Boolean> canPreviousResolver) {
        this.previousListener = listener;
        this.canPreviousResolver = canPreviousResolver;
        return this;
    }

    public Layer<DN, B> onNext(Consumer<Layer> listener, Function<Layer, Boolean> canNextResolver) {
        this.nextListener = listener;
        this.canNextResolver = canNextResolver;
        return this;
    }

    @Override
    public void refresh() {
        super.refresh();
        ((LayerNotifier)this.notifier).refreshToolbar(this.toolbar());
    }

    private LayerToolbar toolbar() {
        LayerToolbar result = new LayerToolbar();
        result.homeButton(new LayerToolbarButton().visible(this.homeAction != null).enabled(this.homeAction != null));
        result.previousButton(new LayerToolbarButton().visible(this.previousListener != null).enabled(this.canPreviousResolver != null ? this.canPreviousResolver.apply(this) : false));
        result.nextButton(new LayerToolbarButton().visible(this.nextListener != null).enabled(this.canNextResolver != null ? this.canNextResolver.apply(this) : false));
        return result;
    }

    public Layer<DN, B> onOpen(Listener listener) {
        this.openListeners.add(listener);
        return this;
    }

    public Layer<DN, B> onClose(Listener listener) {
        this.closeListeners.add(listener);
        return this;
    }

    public void open() {
        ((LayerNotifier)this.notifier).open();
        ((Soul)this.soul()).pushLayer(this);
        this.notifyOpen();
    }

    public void close() {
        ((LayerNotifier)this.notifier).close();
        ((Soul)this.soul()).popLayer();
        this.notifyClose();
    }

    public void home() {
        if (this.homeAction == null) {
            return;
        }
        this.homeAction.openAddress();
    }

    public void previous() {
        if (this.previousListener == null) {
            return;
        }
        this.previousListener.accept(this);
        this.refresh();
    }

    public void next() {
        if (this.nextListener == null) {
            return;
        }
        this.nextListener.accept(this);
        this.refresh();
    }

    public Layer<DN, B> title(String title) {
        this._title(title);
        ((LayerNotifier)this.notifier).refreshTitle(title);
        return this;
    }

    public <C extends Component<?, ?>> C get() {
        return (C)this.template;
    }

    public <C extends Component<?, ?>> C template() {
        return this.get();
    }

    public void template(Component<?, ?> template) {
        this.clear();
        this.template = template;
        this.template.id(UUID.randomUUID().toString());
        this.add(this.template);
    }

    protected Layer<DN, B> _title(String title) {
        this.title = title;
        return this;
    }

    private void notifyOpen() {
        this.openListeners.forEach(l -> l.accept(new Event(this)));
    }

    private void notifyClose() {
        this.closeListeners.forEach(l -> l.accept(new Event(this)));
    }
}

