package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.Stepper;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.spark.UISparkManager;

public class StepperRequester extends io.intino.alexandria.ui.displays.requesters.ComponentRequester {

	public StepperRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		Stepper display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("next")) {
			display.next();
			return;
		}
		else if (operation.equals("back")) {
			display.back();
			return;
		}

		super.execute();
	}
}