package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.SelectorCollectionBox;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.spark.UISparkManager;

public class SelectorCollectionBoxRequester extends BaseSelectorRequester {

	public SelectorCollectionBoxRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		SelectorCollectionBox display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("search")) {
			display.search(manager.fromQuery("v"));
			return;
		}
		else if (operation.equals("clearSelection")) {
			display.clearSelection();
			return;
		}
		else if (operation.equals("unSelect")) {
			display.unSelect(manager.fromQuery("v"));
			return;
		}
		else if (operation.equals("opened")) {
			display.opened();
			return;
		}
		else if (operation.equals("selectOther")) {
			display.selectOther();
			return;
		}

		super.execute();
	}
}