package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.MultipleImage;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.spark.UISparkManager;

public class MultipleImageRequester extends io.intino.alexandria.ui.displays.requesters.ComponentRequester {

	public MultipleImageRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		MultipleImage display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("add")) {
			display.add(manager.fromForm("v"));
			return;
		}
		else if (operation.equals("select")) {
			display.select(manager.fromQuery("v"));
			return;
		}
		else if (operation.equals("remove")) {
			display.remove(Integer.parseInt(manager.fromQuery("v")));
			return;
		}

		super.execute();
	}
}