package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.DashboardShiny;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.spark.UISparkManager;

public class DashboardShinyRequester extends BaseDashboardRequester {

	public DashboardShinyRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		DashboardShiny display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("showSettings")) {
			display.showSettings();
			return;
		}
		else if (operation.equals("hideSettings")) {
			display.hideSettings();
			return;
		}
		else if (operation.equals("saveServerScript")) {
			display.saveServerScript(manager.fromQuery("v"));
			return;
		}
		else if (operation.equals("saveUiScript")) {
			display.saveUiScript(manager.fromQuery("v"));
			return;
		}

		super.execute();
	}
}