package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.Collection;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.spark.UISparkManager;

public class CollectionRequester extends io.intino.alexandria.ui.displays.requesters.ComponentRequester {

	public CollectionRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		Collection display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("selection")) {
			display.selection(java.util.List.of(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), String[].class)));
			return;
		}
		else if (operation.equals("selectAll")) {
			display.selectAll();
			return;
		}

		super.execute();
	}
}