/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.Mark;
import io.intino.alexandria.schemas.Selected;
import io.intino.alexandria.schemas.ToolbarState;
import io.intino.alexandria.ui.displays.components.AbstractBaseSlider;
import io.intino.alexandria.ui.displays.components.slider.Animation;
import io.intino.alexandria.ui.displays.components.slider.Ordinal;
import io.intino.alexandria.ui.displays.components.slider.Range;
import io.intino.alexandria.ui.displays.events.ChangeEvent;
import io.intino.alexandria.ui.displays.events.ChangeListener;
import io.intino.alexandria.ui.displays.notifiers.BaseSliderNotifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;

public abstract class BaseSlider<DN extends BaseSliderNotifier, B extends Box>
extends AbstractBaseSlider<DN, B> {
    private long value = 0L;
    private Ordinal ordinal = null;
    private List<Ordinal> ordinalList = new ArrayList<Ordinal>();
    private Animation animation;
    private ChangeListener changeListener = null;
    private Range range = null;
    private Timer playerStepTimer = null;
    private boolean readonly;
    private List<BaseSlider<DN, B>> observers = new ArrayList<BaseSlider<DN, B>>();

    public BaseSlider(B box) {
        super(box);
    }

    @Override
    public void didMount() {
        super.didMount();
        this.refresh();
    }

    public BaseSlider onChange(ChangeListener listener) {
        this.changeListener = listener;
        return this;
    }

    public long value() {
        return this.value;
    }

    public Ordinal ordinal() {
        return this.ordinal;
    }

    public void selectOrdinal(String name) {
        this.selectOrdinal(name, this.value);
    }

    @Override
    public BaseSlider add(Ordinal ordinal) {
        this._add(ordinal);
        return this;
    }

    public BaseSlider ordinal(Ordinal ordinal) {
        this.ordinal = ordinal;
        this.updateRange();
        return this;
    }

    public Range range() {
        return this.range;
    }

    public boolean readonly() {
        return this.readonly;
    }

    public void value(long value) {
        if (!this.checkRange(value)) {
            return;
        }
        this._value(value);
        this.notifyChange();
    }

    public void addObserver(BaseSlider slider) {
        this.observers.add(slider);
    }

    public void moved(long value) {
        ((BaseSliderNotifier)this.notifier).refreshSelected(this.valueOf(value));
        ((BaseSliderNotifier)this.notifier).refreshToolbar(this.toolbarState());
    }

    public void update(long value) {
        this.value(value);
    }

    public BaseSlider<DN, B> readonly(boolean value) {
        this._readonly(value);
        ((BaseSliderNotifier)this.notifier).refreshReadonly(value);
        return this;
    }

    public BaseSlider<DN, B> marks(Long ... marks) {
        return this.marks(Arrays.stream(marks).map(this::markOf).collect(Collectors.toList()));
    }

    public BaseSlider<DN, B> marks(Mark ... marks) {
        return this.marks(Arrays.stream(marks).collect(Collectors.toList()));
    }

    public BaseSlider<DN, B> marks(List<Mark> markList) {
        ((BaseSliderNotifier)this.notifier).refreshMarks(markList);
        return this;
    }

    protected Mark markOf(long value) {
        return new Mark().value(value).label(this.format(value));
    }

    public void previous() {
        this.value(this.value - 1L);
    }

    public void next() {
        this.value(this.value + 1L);
    }

    public void play() {
        if (this.animation == null) {
            return;
        }
        this.playerStep();
        ((BaseSliderNotifier)this.notifier).refreshToolbar(this.toolbarState());
    }

    public void pause() {
        if (this.animation == null) {
            return;
        }
        if (this.playerStepTimer == null) {
            return;
        }
        this.playerStepTimer.cancel();
        this.playerStepTimer = null;
        ((BaseSliderNotifier)this.notifier).refreshToolbar(this.toolbarState());
    }

    @Override
    public void init() {
        super.init();
        this.refresh();
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.notifier == null) {
            return;
        }
        ((BaseSliderNotifier)this.notifier).refreshToolbar(this.toolbarState());
        ((BaseSliderNotifier)this.notifier).refreshOrdinals(this.ordinals());
        ((BaseSliderNotifier)this.notifier).refreshSelected(this.selectedValue());
        ((BaseSliderNotifier)this.notifier).refreshRange(this.rangeSchema());
        if (this.ordinal() != null) {
            ((BaseSliderNotifier)this.notifier).refreshSelectedOrdinal(this.ordinal().name());
        }
    }

    ChangeListener changeListener() {
        return this.changeListener;
    }

    void notifyChange() {
        this.notifyChange(this.value());
    }

    void notifyChange(long value) {
        ((BaseSliderNotifier)this.notifier).refreshSelected(this.valueOf(value));
        ((BaseSliderNotifier)this.notifier).refreshToolbar(this.toolbarState());
        this.notifyObservers();
        this.notifyListener();
    }

    io.intino.alexandria.schemas.Range rangeSchema() {
        return new io.intino.alexandria.schemas.Range().min(this.range().min()).max(this.range.max());
    }

    void notifyListener() {
        if (this.changeListener == null) {
            return;
        }
        this.changeListener.accept(new ChangeEvent(this, this.value));
    }

    private void notifyObservers() {
        this.observers.forEach(o -> {
            o._value(this.value());
            ((BaseSliderNotifier)o.notifier).refreshSelected(this.selectedValue());
            ((BaseSliderNotifier)o.notifier).refreshToolbar(this.toolbarState());
        });
    }

    public abstract String formattedValue(long var1);

    abstract String format(long var1);

    abstract void updateRange();

    protected BaseSlider _value(long value) {
        this.value = value;
        return this;
    }

    protected BaseSlider _range(long min, long max) {
        this.range = new Range().min(min).max(max);
        if (this.value < min) {
            this.value = min;
        }
        if (this.value > max) {
            this.value = max;
        }
        return this;
    }

    public BaseSlider _add(Ordinal ordinal) {
        this.ordinalList.add(ordinal);
        if (this.ordinal == null && this.ordinalList.size() > 0) {
            this.ordinal(this.ordinalList.get(0));
        }
        return this;
    }

    protected BaseSlider _animation(int interval, boolean loop) {
        this.animation = new Animation().interval(interval).loop(loop);
        return this;
    }

    protected BaseSlider _readonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    void selectOrdinal(String name, long value) {
        this.ordinal(this.ordinalList.stream().filter(o -> o.name().equals(name)).findFirst().orElse(null));
        ((BaseSliderNotifier)this.notifier).refreshSelectedOrdinal(name);
        this.value(value);
    }

    ToolbarState toolbarState() {
        return new ToolbarState().canPrevious(this.canPrevious()).canNext(this.canNext()).playing(this.playerStepTimer != null);
    }

    private List<io.intino.alexandria.schemas.Ordinal> ordinals() {
        return this.ordinalList.stream().map(this::ordinalOf).collect(Collectors.toList());
    }

    private io.intino.alexandria.schemas.Ordinal ordinalOf(Ordinal ordinal) {
        return new io.intino.alexandria.schemas.Ordinal().name(ordinal.name()).label(ordinal.label()).step(ordinal.step());
    }

    private void playerStep() {
        if (!this.canNext().booleanValue() && !this.canLoop()) {
            this.playerStepTimer = null;
            return;
        }
        this.nextValue();
        this.playerStepTimer = new Timer("playerStepTimer");
        this.playerStepTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                BaseSlider.this.playerStep();
                ((BaseSliderNotifier)BaseSlider.this.notifier).refreshToolbar(BaseSlider.this.toolbarState());
            }
        }, this.animation.interval);
    }

    private boolean canLoop() {
        return this.animation != null && this.animation.loop;
    }

    private Boolean canPrevious() {
        return this.value > this.range.min;
    }

    private Boolean canNext() {
        return this.value < this.range.max;
    }

    private void nextValue() {
        if (this.value >= this.range.max) {
            if (this.canLoop()) {
                this.value(this.range.min() - 1L);
            } else {
                return;
            }
        }
        this.value(this.value + 1L);
    }

    private boolean checkRange(long value) {
        if (value > this.range.max) {
            return false;
        }
        return value >= this.range.min;
    }

    private Selected valueOf(long value) {
        String formattedValue = this.formattedValue(value);
        return new Selected().value(value).formattedValue(formattedValue);
    }

    private Selected selectedValue() {
        return this.valueOf(this.value);
    }
}

