package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.NumberEditable;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.spark.UISparkManager;

public class NumberEditableRequester extends BaseNumberRequester {

	public NumberEditableRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		NumberEditable display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("notifyChange")) {
			display.notifyChange(Double.parseDouble(manager.fromQuery("v")));
			return;
		}

		super.execute();
	}
}