package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.DynamicTable;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.services.push.UIMessage;
import io.intino.alexandria.ui.spark.UISparkManager;

public class DynamicTablePushRequester extends io.intino.alexandria.ui.displays.requesters.ComponentPushRequester {

	public void execute(UIClient client, UIMessage message) {
		DynamicTable display = display(client, message);
		if (display == null) return;
		String operation = operation(message);
		String data = data(message);

		if (operation.equals("openRow")) {
			display.openRow(io.intino.alexandria.Json.fromString(data, io.intino.alexandria.schemas.DynamicTableRowParams.class));
			return;
		}
		else if (operation.equals("selectRows")) {
			display.selectRows(java.util.List.of(io.intino.alexandria.Json.fromString(data, io.intino.alexandria.schemas.DynamicTableRowsParams[].class)));
			return;
		}
		else if (operation.equals("showItems")) {
			display.showItems(io.intino.alexandria.Json.fromString(data, io.intino.alexandria.schemas.DynamicTableRowParams.class));
			return;
		}
		else if (operation.equals("visibleColumns")) {
			display.visibleColumns(java.util.List.of(io.intino.alexandria.Json.fromString(data, io.intino.alexandria.schemas.DynamicTableVisibleColumn[].class)));
			return;
		}
		else if (operation.equals("showZeros")) {
			display.showZeros(io.intino.alexandria.Json.fromString(data, Boolean.class));
			return;
		}
		else if (operation.equals("showPercentages")) {
			display.showPercentages(io.intino.alexandria.Json.fromString(data, Boolean.class));
			return;
		}

		super.execute(client, message);
	}

}