package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.BaseSlider;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.services.push.UIMessage;
import io.intino.alexandria.ui.spark.UISparkManager;

public class BaseSliderPushRequester extends io.intino.alexandria.ui.displays.requesters.ComponentPushRequester {

	public void execute(UIClient client, UIMessage message) {
		BaseSlider display = display(client, message);
		if (display == null) return;
		String operation = operation(message);
		String data = data(message);

		if (operation.equals("moved")) {
			display.moved(Long.parseLong(data));
			return;
		}
		else if (operation.equals("update")) {
			display.update(Long.parseLong(data));
			return;
		}
		else if (operation.equals("selectOrdinal")) {
			display.selectOrdinal(data);
			return;
		}
		else if (operation.equals("previous")) {
			display.previous();
			return;
		}
		else if (operation.equals("next")) {
			display.next();
			return;
		}
		else if (operation.equals("play")) {
			display.play();
			return;
		}
		else if (operation.equals("pause")) {
			display.pause();
			return;
		}

		super.execute(client, message);
	}

}