package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.BaseDigitalSignature;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.spark.UISparkManager;

public class BaseDigitalSignatureRequester extends io.intino.alexandria.ui.displays.requesters.ComponentRequester {

	public BaseDigitalSignatureRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		BaseDigitalSignature display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("success")) {
			display.success(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.DigitalSignatureSuccess.class));
			return;
		}
		else if (operation.equals("failure")) {
			display.failure(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.DigitalSignatureFailure.class));
			return;
		}

		super.execute();
	}
}