/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.NumberEditableRange;
import io.intino.alexandria.ui.displays.components.AbstractNumberEditable;
import io.intino.alexandria.ui.displays.components.editable.Editable;
import io.intino.alexandria.ui.displays.events.ChangeEvent;
import io.intino.alexandria.ui.displays.events.ChangeListener;
import io.intino.alexandria.ui.displays.notifiers.NumberEditableNotifier;

public class NumberEditable<DN extends NumberEditableNotifier, B extends Box>
extends AbstractNumberEditable<DN, B>
implements Editable<DN, B> {
    private Double value;
    private Double min;
    private Double max;
    private Double step;
    private boolean readonly;
    private ChangeListener beforeChangeListener = null;
    private ChangeListener changeListener = null;

    public NumberEditable(B box) {
        super(box);
    }

    public Double value() {
        return this.value;
    }

    public Double min() {
        return this.min;
    }

    public NumberEditable<DN, B> min(Double min) {
        this._min(min);
        ((NumberEditableNotifier)this.notifier).refreshRange(this.range());
        return this;
    }

    public Double max() {
        return this.max;
    }

    public NumberEditable<DN, B> max(Double max) {
        this._max(max);
        ((NumberEditableNotifier)this.notifier).refreshRange(this.range());
        return this;
    }

    public Double step() {
        return this.step;
    }

    public NumberEditable<DN, B> range(Double min, Double max) {
        this._min(min);
        this._max(max);
        ((NumberEditableNotifier)this.notifier).refreshRange(this.range());
        return this;
    }

    @Override
    public boolean readonly() {
        return this.readonly;
    }

    @Override
    public void reload() {
        ((NumberEditableNotifier)this.notifier).refresh(this.value());
    }

    @Override
    public NumberEditable<DN, B> readonly(boolean readonly) {
        this._readonly(readonly);
        ((NumberEditableNotifier)this.notifier).refreshReadonly(readonly);
        return this;
    }

    public NumberEditable value(double value) {
        return this.value((Double)value);
    }

    public NumberEditable value(Double value) {
        this._value(value);
        ((NumberEditableNotifier)this.notifier).refresh(value);
        return this;
    }

    public NumberEditable<DN, B> onBeforeChange(ChangeListener listener) {
        this.beforeChangeListener = listener;
        return this;
    }

    @Override
    public NumberEditable<DN, B> onChange(ChangeListener listener) {
        this.changeListener = listener;
        return this;
    }

    public void notifyChange(Double value) {
        if (!this.checkRange(value)) {
            ((NumberEditableNotifier)this.notifier).refreshError(String.format(this.translate("Value out of range: %.1f-%.1f"), this.min != -1.0 ? this.min : -2.147483648E9, this.max != -1.0 ? this.max : 2.147483647E9));
            return;
        }
        ((NumberEditableNotifier)this.notifier).refreshError(null);
        if (this.beforeChangeListener != null) {
            ChangeEvent event = new ChangeEvent(this, value);
            this.beforeChangeListener.accept(event);
            if (event.cancel()) {
                ((NumberEditableNotifier)this.notifier).refresh(this.value);
                return;
            }
        }
        this.value = value;
        if (this.changeListener != null) {
            this.changeListener.accept(new ChangeEvent(this, value));
        }
    }

    private boolean checkRange(Double value) {
        if (this.min != null && this.min != -1.0 && value < this.min) {
            return false;
        }
        return this.max == null || this.max == -1.0 || !(value > this.max);
    }

    protected NumberEditable _value(double value) {
        return this._value((Double)value);
    }

    protected NumberEditable _value(Double value) {
        this.value = value;
        return this;
    }

    protected NumberEditable _min(double value) {
        return this._min((Double)value);
    }

    protected NumberEditable _min(Double min) {
        this.min = min;
        return this;
    }

    protected NumberEditable _max(double value) {
        return this._max((Double)value);
    }

    protected NumberEditable _max(Double max) {
        this.max = max;
        return this;
    }

    protected NumberEditable _step(double value) {
        return this._step((Double)value);
    }

    protected NumberEditable _step(Double step) {
        this.step = step;
        return this;
    }

    protected NumberEditable<DN, B> _readonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    private NumberEditableRange range() {
        NumberEditableRange range = new NumberEditableRange();
        if (this.min != null) {
            range.min(this.min);
        }
        if (this.max != null) {
            range.max(this.max);
        }
        return range;
    }
}

