/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.spark.resources;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.http.pushservice.Client;
import io.intino.alexandria.http.pushservice.MessageCarrier;
import io.intino.alexandria.http.pushservice.PushService;
import io.intino.alexandria.http.pushservice.Session;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifier;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.services.AuthService;
import io.intino.alexandria.ui.services.auth.SessionAuthService;
import io.intino.alexandria.ui.services.auth.Space;
import io.intino.alexandria.ui.services.auth.Token;
import io.intino.alexandria.ui.services.auth.UserInfo;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotInvalidateAccessToken;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotObtainAuthorizationUrl;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotObtainInfo;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotObtainRequestToken;
import io.intino.alexandria.ui.services.auth.exceptions.SpaceAuthCallbackUrlIsNull;
import io.intino.alexandria.ui.services.push.Browser;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.services.push.UISession;
import io.intino.alexandria.ui.services.push.User;
import io.intino.alexandria.ui.spark.UISparkManager;
import io.intino.alexandria.ui.utils.RequestHelper;
import java.io.IOException;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public abstract class Resource
implements io.intino.alexandria.http.Resource {
    static final Map<String, String> authenticationIdMap = new HashMap<String, String>();
    static final Map<String, AuthService.Authentication> authenticationMap = new HashMap<String, AuthService.Authentication>();
    protected final UISparkManager manager;
    private final DisplayNotifierProvider notifierProvider;

    public Resource(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
        this.manager = manager;
        this.notifierProvider = notifierProvider;
    }

    public void execute() throws AlexandriaException {
        this.fillBrowser(this.manager);
    }

    protected void fillDeviceParameter() {
        String device = this.parameterValue("device");
        if (device != null && !device.isEmpty()) {
            this.manager.currentSession().device(device);
        }
    }

    protected String parameterValue(String key) {
        String value = this.manager.fromPath(key);
        if (value == null || value.isEmpty()) {
            value = this.manager.fromQuery(key);
        }
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            if (value.startsWith("enc:")) {
                return new String(Base64.getDecoder().decode(value.replace("enc:", "")));
            }
            return value;
        }
        catch (IllegalArgumentException ex) {
            return value;
        }
    }

    protected boolean isLogged() {
        if (!this.isFederated()) {
            return true;
        }
        String authId = this.manager.fromQuery("authId");
        AuthService.Authentication authentication = this.authenticationOf(this.manager.currentSession(), authId).orElse(null);
        if (authentication == null) {
            return false;
        }
        return this.isLogged(authentication.accessToken());
    }

    protected boolean isLogged(Token accessToken) {
        try {
            if (!this.isFederated()) {
                return true;
            }
            AuthService authService = this.authService();
            if (!authService.valid(accessToken)) {
                return false;
            }
            this.authenticate(this.manager.currentSession(), accessToken);
            return true;
        }
        catch (CouldNotObtainInfo e) {
            Logger.debug((String)e.getMessage());
            return false;
        }
    }

    protected synchronized void authenticate() {
        String authenticate = this.authenticate(this.manager.currentSession(), this.manager.baseUrl());
        if (authenticate == null) {
            authenticate = this.manager.baseUrl();
        }
        this.manager.redirect(authenticate);
    }

    protected synchronized String authenticate(UISession session, String baseUrl) {
        String authId = UUID.randomUUID().toString();
        Space space = this.space();
        space.setAuthId(authId);
        space.setBaseUrl(baseUrl);
        this.saveAuthenticationId(session, authId);
        AuthService.Authentication authentication = this.createAuthentication(session, authId);
        return this.authenticate(authentication);
    }

    protected synchronized void authenticate(UISession session, Token accessToken) throws CouldNotObtainInfo {
        if (!this.isFederated()) {
            return;
        }
        UserInfo info = this.authService().me(accessToken);
        session.user(this.userOf(info));
        session.token(accessToken);
    }

    protected void logout(UISession session) {
        Optional<AuthService.Authentication> authentication = this.authentication(session.id());
        if (!authentication.isPresent()) {
            return;
        }
        try {
            authentication.get().invalidate();
            this.removeAuthentication(session.id());
        }
        catch (CouldNotInvalidateAccessToken error) {
            Logger.debug((String)error.getMessage());
        }
    }

    protected DisplayNotifier notifier(UISession session, UIClient client, Display display) {
        return this.notifierProvider.notifier(display, this.carrier(session, client));
    }

    protected Token accessToken() {
        return Token.build(this.manager.fromQuery("token"));
    }

    protected void fillBrowser(UISparkManager manager, UISession session) {
        Browser browser = session.browser();
        browser.baseUrl(manager.baseUrl());
        browser.basePath(manager.basePath());
        browser.homeUrl(manager.baseUrl());
        browser.userHomeUrl(manager.baseUrl() + manager.userHomePath());
        browser.language(manager.languageFromUrl());
        browser.metadataLanguage(manager.languageFromHeader());
        browser.metadataIpAddress(manager.ipAddressFromHeader());
    }

    Optional<AuthService.Authentication> authentication() {
        return this.authenticationOf(this.manager.currentSession(), this.manager.fromQuery("authId"));
    }

    Optional<AuthService.Authentication> authentication(String sessionId) {
        String authenticationId = authenticationIdMap.get(sessionId);
        return Optional.ofNullable(authenticationMap.get(authenticationId));
    }

    Optional<AuthService.Authentication> authenticationOf(UISession session, String authenticationId) {
        return Optional.ofNullable(authenticationMap.get(this.locateAuthenticationId(session, authenticationId)));
    }

    void removeAuthentication(String sessionId) {
        String authenticationId = authenticationIdMap.get(sessionId);
        authenticationIdMap.remove(sessionId);
        authenticationMap.remove(authenticationId);
    }

    String authenticationId() {
        String sessionId = this.manager.currentSession().id();
        return authenticationIdMap.containsKey(sessionId) ? authenticationIdMap.get(sessionId) : null;
    }

    String home() {
        return this.manager.baseUrl();
    }

    AuthService authService() {
        AuthService authService = this.manager.authService();
        if (authService == null) {
            return null;
        }
        if (authService instanceof SessionAuthService) {
            ((SessionAuthService)authService).inject(this.manager);
        }
        return authService;
    }

    User userOf(UserInfo info) {
        if (info == null) {
            return null;
        }
        User user = new User();
        user.username(info.username());
        user.fullName(info.fullName());
        user.email(info.email());
        user.language(info.language());
        user.photo(info.photo());
        user.roles(info.roleList());
        return user;
    }

    private Space space() {
        AuthService authService = this.authService();
        return authService != null ? authService.space() : null;
    }

    private boolean isFederated() {
        return this.authService() != null;
    }

    private void registerAuthentication(String authenticationId, AuthService.Authentication authentication) {
        authenticationMap.put(authenticationId, authentication);
    }

    private String locateAuthenticationId(UISession session, String authenticationId) {
        if (authenticationId != null && !authenticationId.isEmpty()) {
            this.saveAuthenticationId(session, authenticationId);
            return authenticationId;
        }
        return authenticationIdMap.get(this.manager.currentSession().id());
    }

    private void saveAuthenticationId(UISession session, String authenticationId) {
        authenticationIdMap.put(session.id(), authenticationId);
    }

    private AuthService.Authentication createAuthentication(UISession session, String authenticationId) {
        try {
            this.registerAuthentication(authenticationId, this.authService().authenticate());
            return this.authenticationOf(session, authenticationId).get();
        }
        catch (SpaceAuthCallbackUrlIsNull error) {
            Logger.debug((String)error.getMessage());
            return null;
        }
    }

    private String authenticate(AuthService.Authentication authentication) {
        try {
            AuthService.Authentication.Version version = this.version(authentication);
            if (version == AuthService.Authentication.Version.OAuth1) {
                URL url = authentication.authenticationUrl(authentication.requestToken());
                if (url == null) {
                    return null;
                }
                return RequestHelper.post(url).toString();
            }
            return authentication.authenticationUrl(authentication.requestToken()).toString();
        }
        catch (CouldNotObtainAuthorizationUrl | CouldNotObtainRequestToken | IOException e) {
            Logger.debug((String)e.getMessage());
            return null;
        }
    }

    private AuthService.Authentication.Version version(AuthService.Authentication authentication) {
        try {
            return authentication.version();
        }
        catch (Throwable ex) {
            return AuthService.Authentication.Version.OAuth1;
        }
    }

    private String errorPageUrl() {
        return this.manager.baseUrl() + "/error";
    }

    private MessageCarrier carrier(UISession session, UIClient client) {
        return new MessageCarrier((PushService)this.manager.pushService(), (Session)session, (Client)client);
    }

    private void fillBrowser(UISparkManager manager) {
        this.fillBrowser(manager, manager.currentSession());
    }
}

