/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.services.push;

import io.intino.alexandria.http.pushservice.Client;
import io.intino.alexandria.http.pushservice.Session;
import io.intino.alexandria.http.spark.SparkSession;
import io.intino.alexandria.ui.services.auth.Token;
import io.intino.alexandria.ui.services.push.Browser;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.services.push.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UISession
extends SparkSession<UIClient> {
    private String language;
    private User user;
    private Browser browser;
    private String device = null;
    private Token token = null;
    private Map<String, String> preferences = new HashMap<String, String>();

    public UISession(String id) {
        super(id);
        this.browser = new Browser();
    }

    public User user() {
        return this.user;
    }

    public void user(User user) {
        this.user = user;
    }

    public boolean isLogged() {
        return this.user() != null;
    }

    public Browser browser() {
        return this.browser;
    }

    public void browser(Browser browser) {
        this.browser = browser;
    }

    public String device() {
        return this.device;
    }

    public UISession device(String device) {
        this.device = device;
        return this;
    }

    public boolean isMobile() {
        return this.device != null;
    }

    public UISession language(String language) {
        this.language = language;
        return this;
    }

    public String discoverLanguage() {
        if (this.language != null) {
            return this.language;
        }
        User user = this.user();
        if (user != null && user.language() != null && !user.language().isEmpty()) {
            return user.language();
        }
        String language = this.browser.language();
        if (language != null) {
            return language;
        }
        Client client = this.client();
        if (client != null && client.language() != null) {
            return client.language();
        }
        return "en";
    }

    public void logout() {
        super.logout();
        this.token(null);
        this.user(null);
    }

    public void token(Token token) {
        this.token = token;
    }

    public Token token() {
        return this.token;
    }

    public List<String> preferences() {
        return new ArrayList<String>(this.preferences.values());
    }

    public String preference(String name) {
        return this.preferences.get(name);
    }

    public Session add(String preference, String value) {
        this.preferences.put(preference, value);
        return this;
    }
}

