/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.Json;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.schemas.CollectionItemsRenderedInfo;
import io.intino.alexandria.schemas.CollectionMoreItems;
import io.intino.alexandria.ui.displays.components.PageCollection;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.displays.requesters.CollectionRequester;
import io.intino.alexandria.ui.spark.UISparkManager;

public class PageCollectionRequester
extends CollectionRequester {
    public PageCollectionRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
        super(manager, notifierProvider);
    }

    @Override
    public void execute() throws AlexandriaException {
        PageCollection display = (PageCollection)this.display();
        if (display == null) {
            return;
        }
        String operation = this.operation();
        if (operation.equals("changePage")) {
            display.changePage(Integer.parseInt(this.manager.fromQuery("v")));
            return;
        }
        if (operation.equals("changePageSize")) {
            display.changePageSize(Integer.parseInt(this.manager.fromQuery("v")));
            return;
        }
        if (operation.equals("notifyItemsRendered")) {
            display.notifyItemsRendered((CollectionItemsRenderedInfo)Json.fromString((String)this.manager.fromQuery("v"), CollectionItemsRenderedInfo.class));
            return;
        }
        if (operation.equals("loadNextPage")) {
            display.loadNextPage();
            return;
        }
        if (operation.equals("loadMoreItems")) {
            display.loadMoreItems((CollectionMoreItems)Json.fromString((String)this.manager.fromQuery("v"), CollectionMoreItems.class));
            return;
        }
        super.execute();
    }
}

