/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.components.AbstractOpenLayer;
import io.intino.alexandria.ui.displays.components.Layer;
import io.intino.alexandria.ui.displays.components.addressable.Addressable;
import io.intino.alexandria.ui.displays.events.actionable.OpenLayerEvent;
import io.intino.alexandria.ui.displays.events.actionable.OpenLayerListener;
import io.intino.alexandria.ui.displays.notifiers.OpenLayerNotifier;
import java.util.UUID;

public class OpenLayer<DN extends OpenLayerNotifier, B extends Box>
extends AbstractOpenLayer<DN, B>
implements Addressable {
    private Layer<?, ?> layer;
    private OpenLayerListener openListener = null;
    private String path;
    private String address;
    private Transition transition = Transition.Slide;

    public OpenLayer(B box) {
        super(box);
    }

    public OpenLayer<DN, B> onOpen(OpenLayerListener listener) {
        this.openListener = listener;
        return this;
    }

    public void openAddress() {
        if (!this.validAddress()) {
            return;
        }
        ((OpenLayerNotifier)this.notifier).addressed(this.address);
        ((OpenLayerNotifier)this.notifier).openAddress();
        ((OpenLayerNotifier)this.notifier).addressed(null);
    }

    @Override
    public String path() {
        return this.path;
    }

    protected OpenLayer<DN, B> _path(String path) {
        this.path = path;
        this._address(path);
        return this;
    }

    protected OpenLayer<DN, B> _transition(Transition transition) {
        this.transition = transition;
        return this;
    }

    protected OpenLayer<DN, B> _address(String address) {
        this.address = address;
        return this;
    }

    protected void address(String value) {
        this._address(value);
    }

    public void openLayer() {
        this.layer = this.registerLayer();
        this.layer.open();
        if (this.openListener != null) {
            this.openListener.accept(new OpenLayerEvent(this, this.layer));
        }
        this.openAddress();
    }

    public void execute() {
    }

    private boolean validAddress() {
        return this.address != null && !this.address.contains(":");
    }

    private Layer<?, ?> registerLayer() {
        this.clear();
        this.layer = this.add(this.createLayer());
        return this.layer;
    }

    private Layer<?, ?> createLayer() {
        Layer result = (Layer)new Layer(this.box()).id(UUID.randomUUID().toString());
        result.properties().put("transition", this.transition.name());
        result.bindTo(this);
        return result;
    }

    public static enum Transition {
        Slide,
        Zoom,
        Fade,
        Grow;

    }
}

