/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.Resource;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.Component;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.components.AbstractMultipleImage;
import io.intino.alexandria.ui.displays.components.BaseImage;
import io.intino.alexandria.ui.displays.components.collection.Selectable;
import io.intino.alexandria.ui.displays.components.editable.Editable;
import io.intino.alexandria.ui.displays.events.AddItemEvent;
import io.intino.alexandria.ui.displays.events.ChangeItemEvent;
import io.intino.alexandria.ui.displays.events.RemoveItemEvent;
import io.intino.alexandria.ui.displays.events.editable.AddItemListener;
import io.intino.alexandria.ui.displays.events.editable.ChangeItemListener;
import io.intino.alexandria.ui.displays.events.editable.RemoveItemListener;
import io.intino.alexandria.ui.displays.notifiers.MultipleImageNotifier;
import java.util.List;
import java.util.stream.Collectors;

public abstract class MultipleImage<B extends Box, C extends Component, V>
extends AbstractMultipleImage<B> {
    private boolean readonly;
    private AddItemListener addItemListener;
    private ChangeItemListener changeItemListener;
    private RemoveItemListener removeItemListener;

    public MultipleImage(B box) {
        super(box);
    }

    @Override
    public void didMount() {
        super.didMount();
        ((MultipleImageNotifier)this.notifier).refreshVisibility(this.visible());
    }

    @Override
    public void clear(String container) {
        super.clear(container);
        ((MultipleImageNotifier)this.notifier).reset();
        this.refreshImages();
    }

    @Override
    public synchronized void add(Resource value) {
        C display = this.add();
        this.notifyChange(display, value, this.children().size() - 1);
    }

    public boolean readonly() {
        return this.readonly;
    }

    public MultipleImage<B, C, V> readonly(boolean readonly) {
        this._readonly(readonly);
        ((MultipleImageNotifier)this.notifier).refreshReadonly(readonly);
        return this;
    }

    public C add() {
        return this.add((V)null);
    }

    @Override
    protected abstract C add(V var1);

    public abstract void remove(C var1);

    @Override
    public void removeChild(Display display, String container) {
        super.removeChild(display, container);
        this.refreshImages();
    }

    public void remove(int index) {
        List<Display> children = this.children();
        if (children.size() <= index) {
            return;
        }
        this.notifyRemove(index);
        this.remove((Component)children.get(index));
        this.children().stream().filter(d -> d instanceof Editable).forEach(d -> ((Editable)((Object)d)).reload());
    }

    public void select(String id) {
        this.children().stream().filter(d -> d.id().equals(id)).findFirst().ifPresent(Display::refresh);
    }

    protected MultipleImage<B, C, V> notifyAdd(C child) {
        this.notifyAdd(child, null);
        return this;
    }

    protected MultipleImage<B, C, V> _readonly(boolean readonly) {
        this.readonly = readonly;
        this.children().stream().filter(c -> c instanceof Editable).forEach(c -> this._readonly((Display)c, readonly));
        return this;
    }

    protected MultipleImage<B, C, V> addItemListener(AddItemListener listener) {
        this.addItemListener = listener;
        return this;
    }

    protected MultipleImage<B, C, V> changeItemListener(ChangeItemListener listener) {
        this.changeItemListener = listener;
        return this;
    }

    protected MultipleImage<B, C, V> removeItemListener(RemoveItemListener listener) {
        this.removeItemListener = listener;
        return this;
    }

    protected MultipleImage<B, C, V> notifyAdd(C child, V value) {
        int index = this.children().size() - 1;
        if (this.addItemListener != null) {
            this.addItemListener.accept(new AddItemEvent(this, (Component)child, value, index));
        }
        this.addListeners(child, value, index);
        this._readonly((Display)child, this.readonly);
        this.refreshImages();
        return this;
    }

    private MultipleImage<B, C, V> notifyRemove(int index) {
        if (this.removeItemListener != null) {
            this.removeItemListener.accept(new RemoveItemEvent(this, index));
        }
        this.refreshImages();
        return this;
    }

    private void addListeners(C child, V value, int index) {
        this.addSelectListener(child, value, index);
        this.addChangeListener(child, value, index);
    }

    private void addSelectListener(C child, V value, int index) {
        if (!(child instanceof Selectable)) {
            return;
        }
        ((Selectable)child).onSelect(e -> this.notifySelect(child, e.selection(), index));
    }

    private void addChangeListener(C child, V value, int index) {
        if (!(child instanceof Editable)) {
            return;
        }
        ((Editable)child).onChange(e -> this.notifyChange(child, e.value(), index));
    }

    private void notifySelect(C child, List<V> selection, int index) {
        if (this.changeItemListener == null) {
            return;
        }
        this.changeItemListener.accept(new ChangeItemEvent(this, (Component)child, selection, index));
    }

    private void notifyChange(C child, V value, int index) {
        if (this.changeItemListener == null) {
            return;
        }
        this.changeItemListener.accept(new ChangeItemEvent(this, (Component)child, value, index));
        this.refreshImages();
    }

    private void _readonly(Display c, boolean readonly) {
        if (!(c instanceof Editable)) {
            return;
        }
        ((Editable)((Object)c)).readonly(readonly);
    }

    private void refreshImages() {
        List<BaseImage> children = this.children(BaseImage.class);
        List<String> images = children.stream().map(c -> c.serializedValue()).collect(Collectors.toList());
        ((MultipleImageNotifier)this.notifier).refreshImages(images);
    }
}

