package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.ProxyDisplay;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.spark.UISparkManager;

public class ProxyDisplayRequester extends io.intino.alexandria.ui.displays.requesters.DisplayRequester {

	public ProxyDisplayRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		ProxyDisplay display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("ready")) {
			display.ready();
			return;
		}

		super.execute();
	}
}