/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.UserInfo;
import io.intino.alexandria.ui.Asset;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.components.AbstractUser;
import io.intino.alexandria.ui.displays.events.Event;
import io.intino.alexandria.ui.displays.events.Listener;
import io.intino.alexandria.ui.displays.notifiers.UserNotifier;
import io.intino.alexandria.ui.utils.AvatarUtil;
import java.net.URL;

public class User<DN extends UserNotifier, B extends Box>
extends AbstractUser<B> {
    private Listener refreshListener;

    public User(B box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        this.refresh();
    }

    @Override
    public void unregister() {
    }

    public User onRefresh(Listener listener) {
        this.refreshListener = listener;
        return this;
    }

    @Override
    public void refresh() {
        super.refresh();
        io.intino.alexandria.ui.services.push.User user = this.session().user();
        ((UserNotifier)this.notifier).refresh(this.info(user));
    }

    public void refreshChildren() {
        this.notifyRefresh();
        this.children().forEach(Display::refresh);
    }

    public void logout() {
        this.session().logout();
        ((UserNotifier)this.notifier).redirect(this.session().browser().baseUrl());
    }

    private UserInfo info(io.intino.alexandria.ui.services.push.User user) {
        String fullName = user != null ? user.fullName() : this.translate("anonymous");
        URL photo = user != null ? user.photo() : null;
        String color = this.color() != null ? this.color() : "#2096F3";
        String photoLink = photo != null ? this.photoLink(photo) : AvatarUtil.generateAvatar(fullName, color);
        return new UserInfo().fullName(fullName).photo(photoLink);
    }

    private String photoLink(URL photo) {
        return Asset.toResource(this.baseAssetUrl(), photo).toUrl().toString();
    }

    private void notifyRefresh() {
        if (this.refreshListener != null) {
            this.refreshListener.accept(new Event(this));
        }
    }
}

