/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.components.AbstractActionSwitch;
import io.intino.alexandria.ui.displays.events.actionable.ToggleEvent;
import io.intino.alexandria.ui.displays.events.actionable.ToggleListener;
import io.intino.alexandria.ui.displays.notifiers.ActionSwitchNotifier;

public class ActionSwitch<DN extends ActionSwitchNotifier, B extends Box>
extends AbstractActionSwitch<DN, B> {
    private ToggleEvent.State state;
    private ToggleListener toggleListener;

    public ActionSwitch(B box) {
        super(box);
    }

    @Override
    public void didMount() {
        super.didMount();
        if (this.state != null) {
            ((ActionSwitchNotifier)this.notifier).refreshState(this.state.name());
        }
    }

    public ActionSwitch<DN, B> onToggle(ToggleListener listener) {
        this.toggleListener = listener;
        return this;
    }

    public ToggleEvent.State state() {
        return this.state;
    }

    public ActionSwitch<DN, B> state(ToggleEvent.State state) {
        this._state(state);
        ((ActionSwitchNotifier)this.notifier).refreshState(state.name());
        return this;
    }

    public ActionSwitch<DN, B> toggle(ToggleEvent.State state) {
        this.state(state);
        this.notifyToggle();
        return this;
    }

    public void toggle() {
        this.state = this.state == ToggleEvent.State.On ? ToggleEvent.State.Off : ToggleEvent.State.On;
        this.notifyToggle();
    }

    protected ActionSwitch<DN, B> _state(ToggleEvent.State state) {
        this.state = state;
        return this;
    }

    private void notifyToggle() {
        ((ActionSwitchNotifier)this.notifier).refreshState(this.state.name());
        if (this.toggleListener == null) {
            return;
        }
        this.toggleListener.accept(new ToggleEvent((Display)this, this.state));
    }
}

