/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.model.locations;

import io.intino.alexandria.ui.model.Geometry;
import io.intino.alexandria.ui.model.locations.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Polygon
extends Geometry {
    private List<List<Point>> paths = new ArrayList<List<Point>>();

    public List<List<Point>> paths() {
        return this.paths;
    }

    public Polygon paths(List<List<Point>> paths) {
        this.paths = paths;
        return this;
    }

    public Polygon add(List<Point> points) {
        this.paths.add(points);
        return this;
    }

    @Override
    public String toWkt() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.paths.size(); ++i) {
            result.append(this.pathToWkt(this.paths.get(i)));
        }
        return String.format("POLYGON(%s)", String.join((CharSequence)",", result.toString()));
    }

    private String pathToWkt(List<Point> path) {
        return "(" + path.stream().map(p -> p.latitude() + " " + p.longitude()).collect(Collectors.joining(",")) + ")";
    }
}

