/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.components.FileEditable;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.displays.requesters.BaseFileRequester;
import io.intino.alexandria.ui.spark.UIFile;
import io.intino.alexandria.ui.spark.UISparkManager;

public class FileEditableRequester
extends BaseFileRequester {
    public FileEditableRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
        super(manager, notifierProvider);
    }

    @Override
    public void execute() throws AlexandriaException {
        FileEditable display = (FileEditable)this.display();
        if (display == null) {
            return;
        }
        String operation = this.operation();
        if (operation.equals("notifyUploading")) {
            display.notifyUploading();
            return;
        }
        if (operation.equals("notifyChange")) {
            display.notifyChange(this.manager.fromForm("v"));
            return;
        }
        if (operation.equals("downloadFile")) {
            UIFile file = display.downloadFile();
            if (file == null) {
                return;
            }
            this.manager.write(file.content(), file.label(), file.embedded());
            return;
        }
        super.execute();
    }
}

