/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.notifiers;

import io.intino.alexandria.Json;
import io.intino.alexandria.http.pushservice.MessageCarrier;
import io.intino.alexandria.ui.Message;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.PropertyList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisplayNotifier {
    Display display;
    MessageCarrier carrier;

    public DisplayNotifier(Display display, MessageCarrier carrier) {
        this.display = display;
        this.carrier = carrier;
    }

    public <D extends Display> void add(D child, String container) {
        this.put("addInstance", this.addMetadata(this.registerParameters(child, container, -1)));
    }

    public <D extends Display> void add(List<D> children, String container) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("c", container);
        params.put("value", this.registerParameters(children, -1, container));
        this.put("addInstances", this.addMetadata(params));
    }

    public <D extends Display> void insert(D child, int index, String container) {
        this.put("insertInstance", this.addMetadata(this.registerParameters(child, container, index)));
    }

    public <D extends Display> void insert(List<D> children, int index, String container) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("c", container);
        params.put("value", this.registerParameters(children, index, container));
        this.put("insertInstances", this.addMetadata(params));
    }

    public void remove(String id, String container) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        params.put("c", container);
        this.put("removeInstance", this.addMetadata(params));
    }

    public void redirect() {
        this.redirect(null);
    }

    public void redirect(String url) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("url", url);
        this.put("redirect", this.addMetadata(params));
    }

    public void clearContainer(String container) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("c", container);
        this.put("clearContainer", this.addMetadata(params));
    }

    public void addressed(String address) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("address", address);
        this.put("addressed", this.addMetadata(params));
    }

    protected void put(String message) {
        this.put(message, this.addMetadata(new HashMap<String, Object>()));
    }

    protected void put(String message, Map<String, Object> parameters) {
        this.carrier.notifyClient(Json.toString((Object)new Message(message, this.addMetadata(parameters))));
    }

    protected void put(String message, Object parameter) {
        this.carrier.notifyClient(Json.toString((Object)new Message(message, this.addMetadata(Collections.singletonMap(message, parameter)))));
    }

    protected void put(String message, String parameter, Object value) {
        this.carrier.notifyClient(Json.toString((Object)new Message(message, this.addMetadata(Collections.singletonMap(parameter, value)))));
    }

    protected void putToDisplay(String message, Map<String, Object> parameters) {
        this.carrier.notifyClient(Json.toString((Object)new Message(message, this.addMetadata(parameters))));
    }

    protected void putToDisplay(String message) {
        this.putToDisplay(message, this.addMetadata(new HashMap<String, Object>()));
    }

    protected void putToDisplay(String message, Object parameter) {
        this.carrier.notifyClient(Json.toString((Object)new Message(message, this.addMetadata(Collections.singletonMap(message, parameter)))));
    }

    protected void putToDisplay(String message, String parameter, Object value) {
        this.carrier.notifyClient(Json.toString((Object)new Message(message, this.addMetadata(Collections.singletonMap(parameter, value)))));
    }

    protected void putToAll(String message) {
        this.putToAll(message, this.addMetadata(new HashMap<String, Object>()));
    }

    protected void putToAll(String message, Map<String, Object> parameters) {
        this.carrier.notifyAll(Json.toString((Object)new Message(message, this.addMetadata(parameters))));
    }

    protected void putToAll(String message, Object parameter) {
        this.carrier.notifyAll(Json.toString((Object)new Message(message, this.addMetadata(Collections.singletonMap(message, parameter)))));
    }

    protected void putToAll(String message, String parameter, Object value) {
        this.carrier.notifyAll(Json.toString((Object)new Message(message, this.addMetadata(Collections.singletonMap(parameter, value)))));
    }

    private Map<String, Object> addMetadata(Map<String, Object> parameters) {
        HashMap<String, Object> parametersWithId = new HashMap<String, Object>(parameters);
        parametersWithId.put("i", this.display.id());
        parametersWithId.put("n", this.display.name());
        if (this.display.owner() != null) {
            parametersWithId.put("o", this.display.owner().path());
        }
        return parametersWithId;
    }

    private <D extends Display> List<Map<String, Object>> registerParameters(List<D> children, int index, String container) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < children.size(); ++i) {
            result.add(this.registerParameters((Display)children.get(i), container, i + index));
        }
        return result;
    }

    private <D extends Display> Map<String, Object> registerParameters(D display, String container, int index) {
        String type = display.getClass().getSimpleName();
        return this.registerParameters(type, display.properties(), container, index);
    }

    private Map<String, Object> registerParameters(String type, PropertyList propertyList, String container, int index) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("tp", type);
        parameters.put("pl", propertyList);
        parameters.put("c", container);
        if (index != -1) {
            parameters.put("idx", index);
        }
        return parameters;
    }
}

