/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays;

import io.intino.alexandria.Json;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.International;
import io.intino.alexandria.ui.Soul;
import io.intino.alexandria.ui.SoulProvider;
import io.intino.alexandria.ui.displays.DisplayRepository;
import io.intino.alexandria.ui.displays.PropertyList;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifier;
import io.intino.alexandria.ui.resources.Asset;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.services.push.UISession;
import io.intino.alexandria.ui.utils.UUIDUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class Display<N extends DisplayNotifier, B extends Box> {
    private final B box;
    private String id;
    private final Map<String, List<Display>> children = new HashMap<String, List<Display>>();
    private Map<String, List<Display>> promisedChildren = new HashMap<String, List<Display>>();
    protected DisplayRepository repository;
    protected N notifier;
    protected String container = null;
    private SoulProvider soulProvider;
    private UISession session;
    private Display parent = null;
    private Display owner = null;
    private List<String> route = new ArrayList<String>();
    private PropertyList propertyList = new PropertyList();
    private String label = "";
    private String name = "";
    public static final String DefaultInstanceContainer = "__elements";

    public Display(B box) {
        this.box = box;
        this.id = UUID.randomUUID().toString();
        this.propertyList.put("id", this.id);
    }

    public <D extends Display> D id(String id) {
        this.id = id;
        this.propertyList.put("id", id);
        return (D)this;
    }

    public Display owner() {
        return this.owner;
    }

    public <D extends Display> D owner(Display owner) {
        this.owner = owner;
        this.propertyList.put("o", owner.path());
        return (D)this;
    }

    public String label() {
        return this.label;
    }

    public <D extends Display> D label(String label) {
        this.label = label;
        return (D)this;
    }

    public String path() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.id());
        for (Object owner = this.parent(); owner != null; owner = ((Display)owner).parent()) {
            result.add(((Display)owner).id());
            if (UUIDUtil.isUUID(((Display)owner).id())) break;
        }
        Collections.reverse(result);
        return String.join((CharSequence)".", result);
    }

    public B box() {
        return this.box;
    }

    public void inject(UISession session) {
        this.session = session;
    }

    public void inject(N notifier) {
        this.notifier = notifier;
    }

    public void inject(DisplayRepository repository) {
        this.repository = repository;
    }

    public void inject(SoulProvider soulProvider) {
        this.soulProvider = soulProvider;
    }

    public PropertyList properties() {
        return this.propertyList;
    }

    public void route(String ... paths) {
        this.route(Arrays.asList(paths));
    }

    public void route(List<String> paths) {
        this.route = paths;
    }

    public List<String> route() {
        return this.route;
    }

    public String routePath() {
        return this.route.size() > 0 ? this.route.get(0) : null;
    }

    public List<String> routeSubPath() {
        return this.route.size() > 1 ? this.route.subList(1, this.route.size()) : Collections.emptyList();
    }

    public void setLanguage(String language) {
        this.propagateLanguageChanged(language);
    }

    public UISession session() {
        return this.session;
    }

    public void init() {
    }

    protected <S extends Soul> S soul() {
        return (S)this.soulProvider.soul();
    }

    protected String assetUrl(URL asset) {
        return Asset.toResource(((Soul)this.soul()).baseAssetUrl(), asset).toUrl().toString();
    }

    protected String assetUrl(URL asset, String label) {
        return Asset.toResource(((Soul)this.soul()).baseAssetUrl(), asset).setLabel(label).toUrl().toString();
    }

    private void propagateLanguageChanged(String language) {
        if (this instanceof International) {
            ((International)((Object)this)).onChangeLanguage(language);
        }
        this.allChildren().forEach(c -> c.propagateLanguageChanged(language));
    }

    public void update() {
    }

    public void didMount() {
    }

    public void refresh() {
    }

    public String id() {
        return this.id;
    }

    public <T> T trace(Class<T> clazz) {
        return this.trace(clazz, this.id());
    }

    public <T> T trace(Class<T> clazz, String name) {
        String value = ((UIClient)this.session().client()).cookie(name);
        return (T)(value != null ? Json.fromString((String)URLDecoder.decode(value, StandardCharsets.UTF_8), clazz) : null);
    }

    public void remove() {
        ((DisplayNotifier)this.notifier).remove(this.id, DefaultInstanceContainer);
    }

    public List<Display> children() {
        return new ArrayList<Display>(this.allChildren());
    }

    public List<Display> promisedChildren() {
        return new ArrayList<Display>(this.allPromisedChildren());
    }

    public List<Display> promisedChildren(String container) {
        return this.promisedChildren.containsKey(container) ? this.promisedChildren.get(container) : new ArrayList<Display>();
    }

    public List<Display> promisedChildren(List<String> ids) {
        return this.allPromisedChildren().stream().filter(c -> ids.contains(c.id())).collect(Collectors.toList());
    }

    public <T extends Display> List<T> children(Class<T> clazz) {
        return this.allChildren().stream().filter(child -> clazz.isAssignableFrom(child.getClass())).map(clazz::cast).collect(Collectors.toList());
    }

    public List<Display> children(List<String> ids) {
        return this.allChildren().stream().filter(child -> ids.contains(child.id())).collect(Collectors.toList());
    }

    public <T extends Display> T child(Class<T> clazz) {
        return (T)((Display)this.children(clazz).stream().findFirst().map(clazz::cast).orElse(null));
    }

    public <T extends Display> T child(int position) {
        List<Display> children = this.children();
        return (T)(children.size() > position ? this.children().get(position) : null);
    }

    public <T extends Display> T child(String id) {
        return (T)((Display)this.children().stream().filter(d -> d.id().equals(id)).findFirst().orElse(null));
    }

    public <D extends Display> D register(D child) {
        child.parent(this);
        this.promisedChildren(child.container).remove(child);
        this.repository.register(child);
        this.addChild(child, this.container(child));
        child.init();
        return child;
    }

    public <D extends Display> D add(D child) {
        return this.add(child, this.container(child));
    }

    public <D extends Display> D add(D child, String container) {
        this.addPromise(child, container);
        this.register(child);
        return child;
    }

    public <D extends Display> D addPromise(D child) {
        return this.addPromise(child, this.container(child));
    }

    public <D extends Display> D addPromise(D child, String container) {
        return this.registerPromise(child, container, (String containerName) -> ((DisplayNotifier)this.notifier).add(child, (String)containerName));
    }

    public <D extends Display> List<D> addPromise(List<D> children, String container) {
        return this.registerPromise(children, container, (String containerName) -> ((DisplayNotifier)this.notifier).add(children, (String)containerName));
    }

    public <D extends Display> D insertPromise(D child, int index) {
        return this.insertPromise(child, index, this.container(child));
    }

    public <D extends Display> D insertPromise(D child, int index, String container) {
        return this.registerPromise(child, container, (String containerName) -> ((DisplayNotifier)this.notifier).insert(child, index, (String)containerName));
    }

    public <D extends Display> List<D> insertPromise(List<D> children, int index, String container) {
        return this.registerPromise(children, container, (String containerName) -> ((DisplayNotifier)this.notifier).insert(children, index, (String)containerName));
    }

    public <T extends Display> T parent() {
        return (T)this.parent;
    }

    public <T extends Display> T parent(Class<T> type) {
        return this.parent(this.parent, type);
    }

    public <T extends Display> T parent(Display display, Class<T> type) {
        if (display == null) {
            return null;
        }
        if (type.isAssignableFrom(display.getClass())) {
            return (T)display;
        }
        return this.parent((Display)display.parent(), type);
    }

    private void parent(Display parent) {
        this.parent = parent;
    }

    public void remove(Class<? extends Display> clazz) {
        this.remove(clazz, DefaultInstanceContainer);
    }

    public void remove(Class<? extends Display> clazz, String container) {
        List<? extends Display> childrenToRemove = this.children(clazz);
        childrenToRemove.forEach(d -> this.removeChild((Display)d, container));
    }

    public void clear() {
        this.clear(DefaultInstanceContainer);
    }

    public void clear(String container) {
        this.children(container).ifPresent(children -> children.forEach(d -> {
            d.remove();
            this.repository.remove(d.id);
        }));
        this.children.remove(container);
        this.promisedChildren.remove(container);
        ((DisplayNotifier)this.notifier).clearContainer(container);
    }

    public void removeChild(Display display) {
        this.removeChild(display, null);
    }

    public void removeChild(Display display, String container) {
        display.remove();
        ((DisplayNotifier)this.notifier).remove(display.id, container);
        this.children.get(container).remove(display);
        this.repository.remove(display.id);
    }

    public String name() {
        return this.name != null && !this.name.isEmpty() ? this.name : Display.nameOf(this.getClass());
    }

    public <D extends Display> D name(String name) {
        this.name = name;
        return (D)this;
    }

    public static String nameOf(Class<? extends Display> clazz) {
        String name = clazz.getSimpleName();
        int index = name.lastIndexOf("Display");
        return index != -1 ? name.substring(0, index) : name;
    }

    public URL baseAssetUrl() {
        try {
            return new URL(this.session().browser().baseAssetUrl());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private Optional<List<Display>> children(String container) {
        return Optional.ofNullable(this.children.getOrDefault(container, null));
    }

    private List<Display> allChildren() {
        return this.children.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<Display> allPromisedChildren() {
        return this.promisedChildren.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void addChild(Display child, String container) {
        if (!this.children.containsKey(container)) {
            this.children.put(container, new ArrayList());
        }
        this.children.get(container).add(child);
    }

    private void addPromisedChild(Display child, String container) {
        if (!this.promisedChildren.containsKey(container)) {
            this.promisedChildren.put(container, new ArrayList());
        }
        child.container = container;
        this.promisedChildren.get(container).add(child);
    }

    private String container(Display child) {
        return child.container != null ? child.container : DefaultInstanceContainer;
    }

    private <D extends Display> D registerPromise(D child, String container, Consumer<String> consumer) {
        String containerName = container != null ? container : DefaultInstanceContainer;
        child.owner(this);
        consumer.accept(containerName);
        this.addPromisedChild(child, containerName);
        return child;
    }

    private <D extends Display> List<D> registerPromise(List<D> children, String container, Consumer<String> consumer) {
        String containerName = container != null ? container : DefaultInstanceContainer;
        children.forEach(c -> c.owner(this));
        consumer.accept(container);
        children.forEach(c -> this.addPromisedChild((Display)c, containerName));
        return children;
    }
}

