package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.DynamicTable;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.spark.UISparkManager;

public class DynamicTableRequester extends PageCollectionRequester {

	public DynamicTableRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		DynamicTable display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("selectRow")) {
			display.selectRow(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.DynamicTableRowParams.class));
			return;
		}
		else if (operation.equals("showItems")) {
			display.showItems(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.DynamicTableRowParams.class));
			return;
		}
		else if (operation.equals("visibleColumns")) {
			display.visibleColumns(java.util.List.of(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.DynamicTableVisibleColumn[].class)));
			return;
		}
		else if (operation.equals("showZeros")) {
			display.showZeros(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), Boolean.class));
			return;
		}
		else if (operation.equals("showPercentages")) {
			display.showPercentages(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), Boolean.class));
			return;
		}

		super.execute();
	}
}