package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.DownloadSelection;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.spark.UISparkManager;

public class DownloadSelectionRequester extends BaseSelectionActionRequester {

	public DownloadSelectionRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		DownloadSelection display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("changeParams")) {
			display.changeParams(manager.fromQuery("v"));
			return;
		}
		else if (operation.equals("execute")) {
			io.intino.alexandria.ui.spark.UIFile file = display.execute();
			if (file == null) return;
			manager.write(file.content(), file.label(), file.embedded());
			return;
		}

		super.execute();
	}
}