import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiHeader from "alexandria-ui-elements/src/displays/components/Header";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiOpenSite from "alexandria-ui-elements/src/displays/components/OpenSite";
import UiOpenPage from "alexandria-ui-elements/src/displays/components/OpenPage";
import UiSetDarkMode from "alexandria-ui-elements/src/displays/components/SetDarkMode";
import UiSetLightMode from "alexandria-ui-elements/src/displays/components/SetLightMode";
import DisplaysWidgetMold from "ui-elements/gen/displays/templates/WidgetMold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import WidgetTypeTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import WidgetTypeTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class WidgetTypeTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new WidgetTypeTemplateNotifier(this);
		this.requester = new WidgetTypeTemplateRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" style={{...this.props.style,...display}}>
				<UiHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1172386912" format="air" color="white" position="relative" width="-1px" height="100px" elevation={4}>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1172386912.a_248551116" layout="horizontal center flexible" spacing="24">
						<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1172386912.a_248551116.a149265222" width="80px" height="80px">
						</UiImage>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1172386912.a_248551116.a_607116561" format="h3" mode="normal" value="intino">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1172386912.a_248551116.a790298661" format="headerToolbar" layout="horizontal center flexible" spacing="24">
							<UiOpenSite context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1172386912.a_248551116.a790298661.a_1216630451" title="home" target="self" mode="Link" size="Medium">
							</UiOpenSite>
							<UiOpenPage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1172386912.a_248551116.a790298661.a1334135757" title="widgets" target="self" mode="Link" size="Medium">
							</UiOpenPage>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1172386912.a_248551116.a_1018732861" layout="horizontal endjustified">
							<UiSetDarkMode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1172386912.a_248551116.a_1018732861.a1618713635" title="set dark mode" target="self" mode="MaterialIconButton" icon="Brightness4" size="Medium">
							</UiSetDarkMode>
							<UiSetLightMode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1172386912.a_248551116.a_1018732861.a2106074448" title="set light mode" target="self" mode="MaterialIconButton" icon="Brightness7" size="Medium">
							</UiSetLightMode>
						</UiBlock>
					</UiBlock>
				</UiHeader>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1808307852" format="containerAirLarge" layout="vertical">
					<DisplaysWidgetMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1808307852.a_1239848974">
					</DisplaysWidgetMold>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(WidgetTypeTemplate));
DisplayFactory.register("WidgetTypeTemplate", withStyles(styles, { withTheme: true })(withSnackbar(WidgetTypeTemplate)));