import ActionableRequester from "./ActionableRequester"

export default class CloseLayerRequester extends ActionableRequester {
	constructor(element) {
		super(element);
	};
	execute = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "execute", s: "closelayer", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	didMount = () => {
		this.pushService.send({ op: "didMount", s: "closelayer", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
}