import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiLocation from "alexandria-ui-elements/src/displays/components/Location";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiLocationEditable from "alexandria-ui-elements/src/displays/components/LocationEditable";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import LocationExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import LocationExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class LocationExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new LocationExamplesMoldNotifier(this);
		this.requester = new LocationExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1638176027" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1638176027.a1231737593" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1638176027.a1231737593.a_1983121408" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1638176027.a1231737593.a531418593" format="filledNoAirLarge" layout="vertical" spacing="8">
							<UiLocation context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1638176027.a1231737593.a531418593.a_429932134" center={{lat:28.146773457066104,lng:-15.418557420532238}} zoom={{min:1,max:18,defaultZoom:6}} controls="all">
							</UiLocation>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1638176027.a1231737593.a531418593.a_782228399" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1638176027.a1231737593.a531418593.a_782228399.a_474715924" mode="normal" language="Html" value="Location location&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Zoom(defaultZoom=6, min=1, max=18)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Center(latitude=28.146773457066104, longitude=-15.418557420532238)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1638176027.a_571968176" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1638176027.a_571968176.a_847858747" format="h6" mode="normal" value="No facets with location">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1638176027.a_571968176.a1396476792" format="filledNoAirLarge" layout="vertical" spacing="8">
							<UiLocation context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1638176027.a_571968176.a1396476792.a_2109102786" center={{lat:28.146773457066104,lng:-15.418557420532238}} zoom={{min:1,max:18,defaultZoom:6}} controls="all">
							</UiLocation>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1638176027.a_571968176.a1396476792.a1661654645" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1638176027.a_571968176.a1396476792.a1661654645.a_352593264" mode="normal" language="Html" value="Location location&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;value='POINT(28.146773457066104,-15.146773457066104)'&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Zoom(defaultZoom=6, min=1, max=18)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Center(latitude=28.146773457066104, longitude=-15.418557420532238)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1638176027.a_359552754" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1638176027.a_359552754.a_164744092" format="h6" mode="normal" value="Editable facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1638176027.a_359552754.a787567165" format="filledNoAirLarge" layout="vertical" spacing="8">
							<UiLocationEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1638176027.a_359552754.a787567165.a213290851" center={{lat:28.146773457066104,lng:-15.418557420532238}} zoom={{min:1,max:18,defaultZoom:6}} controls="all">
							</UiLocationEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1638176027.a_359552754.a787567165.a_954009497" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1638176027.a_359552754.a787567165.a_954009497.a_522428342" mode="normal" language="Html" value="Location location as Editable&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Zoom(defaultZoom=6, min=1, max=18)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Center(latitude=28.146773457066104, longitude=-15.418557420532238)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1638176027.a1869036018" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1638176027.a1869036018.a1983864254" format="h6" mode="normal" value="Editable facet with modes">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1638176027.a1869036018.a_314716351" format="filledNoAirLarge" layout="vertical" spacing="8">
							<UiLocationEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1638176027.a1869036018.a_314716351.a962591644" center={{lat:28.146773457066104,lng:-15.418557420532238}} zoom={{min:1,max:18,defaultZoom:6}} modes={["Rectangle"]} controls="all">
							</UiLocationEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1638176027.a1869036018.a_314716351.a2019907463" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1638176027.a1869036018.a_314716351.a2019907463.a953004015" mode="normal" language="Html" value="Location location as Editable&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;modes=Rectangle&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Zoom(defaultZoom=6, min=1, max=18)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Center(latitude=28.146773457066104, longitude=-15.418557420532238)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(LocationExamplesMold));
DisplayFactory.register("LocationExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(LocationExamplesMold)));