import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiDownload from "alexandria-ui-elements/src/displays/components/Download";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import DownloadExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import DownloadExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class DownloadExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new DownloadExamplesMoldNotifier(this);
		this.requester = new DownloadExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1263017269" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1263017269.a1298648004" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1263017269.a1298648004.a_494569133" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1263017269.a1298648004.a726483599" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiDownload context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1263017269.a1298648004.a726483599.a_558667276" title="download..." target="self" mode="Button" size="Medium">
							</UiDownload>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1263017269.a1298648004.a693906552" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1263017269.a1298648004.a693906552.a_1194980110" mode="normal" language="Html" value="Button(title=&quot;download...&quot;) as Download">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1263017269.a_1812193550" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1263017269.a_1812193550.a_586405152" format="h6" mode="normal" value="No facets with options">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1263017269.a_1812193550.a112956054" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiDownload context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1263017269.a_1812193550.a112956054.a_1064225900" title="download..." target="self" mode="Button" size="Medium" options={["a","b","c"]}>
							</UiDownload>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1263017269.a_1812193550.a17182447" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1263017269.a_1812193550.a17182447.a1803910260" mode="normal" language="Html" value="Button(title=&quot;download...&quot;) as Download(options=&quot;a&quot; &quot;b&quot; &quot;c&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(DownloadExamplesMold));
DisplayFactory.register("DownloadExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(DownloadExamplesMold)));