import Notifier from "alexandria-ui-elements/src/displays/notifiers/ComponentNotifier";

export default class HtmlViewerNotifier extends Notifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("refresh").toSelf().execute((parameters) => this.element.refresh(parameters.v));
		this.when("refreshOperations").toSelf().execute((parameters) => this.element.refreshOperations(parameters.v));
		this.when("print").toSelf().execute((parameters) => this.element.print(parameters.v));
		this.pushLinked = true;
	};
}