import Requester from "./Requester";

export default class LayerRequester extends Requester {
	constructor(element) {
		super(element);
	};
	open = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "open", s: "layer", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	home = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "home", s: "layer", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	previous = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "previous", s: "layer", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	next = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "next", s: "layer", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	close = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "close", s: "layer", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	execute = (value) => {
		if (this.addToHistory(value)) return;
		this.pushService.send({ app: this.element.context, op: "execute", s: "layer", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	didMount = () => {
		this.pushService.send({ op: "didMount", s: "layer", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
}