import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiWizard from "alexandria-ui-elements/src/displays/components/Wizard";
import UiStep from "alexandria-ui-elements/src/displays/components/Step";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiDate from "alexandria-ui-elements/src/displays/components/Date";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiWizardNavigator from "alexandria-ui-elements/src/displays/components/WizardNavigator";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import WizardExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import WizardExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class WizardExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new WizardExamplesMoldNotifier(this);
		this.requester = new WizardExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_679436140" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_679436140.a_385995082" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_679436140.a410210639" format="filledNoAirExtraLarge" layout="vertical">
							<UiWizard context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_679436140.a410210639.a_1587960786" style="Full"    orientation="horizontal" position="bottom">
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_679436140.a410210639.a_1587960786.a580157332" label="Step1">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_679436140.a410210639.a_1587960786.a580157332.a407569286" mode="normal" value="hola1">
									</UiText>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_679436140.a410210639.a_1587960786.a580157333" label="Step2">
									<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_679436140.a410210639.a_1587960786.a580157333.a_597954396" width="200px" height="150px">
									</UiImage>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_679436140.a410210639.a_1587960786.a580157334" label="Step3">
									<UiDate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_679436140.a410210639.a_1587960786.a580157334.a331495522" pattern="DD/MM/YYYY">
									</UiDate>
								</UiStep>
							</UiWizard>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_679436140.a410210639.a1191915005" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_679436140.a410210639.a1191915005.a_591524451" mode="normal" language="Html" value="Wizard&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step1 as Labeled&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step1&quot;&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;hola1&quot;)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step2 as Labeled&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step2&quot;&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Image(defaultValue =&quot; images/image.jpg&quot;) as Absolute(width = 200px, height = 150px)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step3 as Labeled&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step3&quot;&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Date(pattern = &quot;DD/MM/YYYY&quot;)&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a588549159" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a588549159.a319666716" format="h6" mode="normal" value="No facet. Position top, Orientation horizontal">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a588549159.a_1430437909" format="filledNoAirExtraLarge" layout="vertical">
							<UiWizard context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a588549159.a_1430437909.a773398387" style="Full"    orientation="horizontal" position="top">
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a588549159.a_1430437909.a773398387.a_996560100" label="Step1">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a588549159.a_1430437909.a773398387.a_996560100.a137251445" mode="normal" value="Hello">
									</UiText>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a588549159.a_1430437909.a773398387.a_996560099" label="Step2">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a588549159.a_1430437909.a773398387.a_996560099.a_1667488200" mode="normal" value="World">
									</UiText>
								</UiStep>
							</UiWizard>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a588549159.a_1430437909.a166653755" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a588549159.a_1430437909.a166653755.a_1396349447" mode="normal" language="Html" value="Wizard&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;position = Top&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step4 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step1&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;Hello&quot;)&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step5 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step2&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;World&quot;)&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_199991588" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_199991588.a1676847955" format="h6" mode="normal" value="No facet. Position left, Orientation vertical">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_199991588.a1928353190" format="filledNoAirExtraLarge" layout="vertical">
							<UiWizard context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_199991588.a1928353190.a1555468748" style="Full"    orientation="vertical" position="left">
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_199991588.a1928353190.a1555468748.a_1276887369" label="Step1">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_199991588.a1928353190.a1555468748.a_1276887369.a_1893165450" mode="normal" value="Hello">
									</UiText>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_199991588.a1928353190.a1555468748.a_1276887368" label="Step2">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_199991588.a1928353190.a1555468748.a_1276887368.a_1429734332" mode="normal" value="World">
									</UiText>
								</UiStep>
							</UiWizard>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_199991588.a1928353190.a111009133" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_199991588.a1928353190.a111009133.a_423937181" mode="normal" language="Html" value="Wizard&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;position = Left&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;orientation = Vertical&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step6 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step1&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;Hello&quot;)&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step7 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step2&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;World&quot;)&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_306109941" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_306109941.a_823094160" format="h6" mode="normal" value="No facet. Position right, Orientation vertical">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_306109941.a_1254327775" format="filledNoAirExtraLarge" layout="vertical">
							<UiWizard context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_306109941.a_1254327775.a2119876562" style="Full"    orientation="vertical" position="right">
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_306109941.a_1254327775.a2119876562.a_1500295105" label="Step1">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_306109941.a_1254327775.a2119876562.a_1500295105.a_170481708" mode="normal" value="Hello">
									</UiText>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_306109941.a_1254327775.a2119876562.a_1500295104" label="Step2">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_306109941.a_1254327775.a2119876562.a_1500295104.a_1975221353" mode="normal" value="World">
									</UiText>
								</UiStep>
							</UiWizard>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_306109941.a_1254327775.a_1420834399" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a_306109941.a_1254327775.a_1420834399.a104522010" mode="normal" language="Html" value="Wizard&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;position = Right&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;orientation = Vertical&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step8 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step1&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;Hello&quot;)&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step9 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step2&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;World&quot;)&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a1824789476" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a1824789476.a_1295716147" format="h6" mode="normal" value="MaterialIcon facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a1824789476.a_351895176" format="filledNoAirExtraLarge" layout="vertical">
							<UiWizard context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a1824789476.a_351895176.a_1330314560" style="Full"    orientation="horizontal" position="bottom">
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a1824789476.a_351895176.a_1330314560.a556133450" label="Step1" icon="AddCircle">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a1824789476.a_351895176.a_1330314560.a556133450.a36863273" mode="normal" value="Hello">
									</UiText>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a1824789476.a_351895176.a_1330314560.a556133451" label="Step2" icon="Menu">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a1824789476.a_351895176.a_1330314560.a556133451.a_2120834515" mode="normal" value="World">
									</UiText>
								</UiStep>
							</UiWizard>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a1824789476.a_351895176.a_853298702" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a1824789476.a_351895176.a_853298702.a_1725346976" mode="normal" language="Html" value="Wizard&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step10 as Labeled MaterialIcon&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step1&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;icon = &quot;AddCircle&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;Hello&quot;)&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step11 as Labeled MaterialIcon&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step2&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;icon = &quot;Menu&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;World&quot;)&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a1017730618" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a1017730618.a1523934943" format="h6" mode="normal" value="No facet. Content only style">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a1017730618.a201911144" format="filledNoAirExtraLarge" layout="vertical">
							<UiWizard context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a1017730618.a201911144.a152820379" style="ContentOnly"    orientation="horizontal" position="bottom" confirmMessage="Are you sure to finish?">
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a1017730618.a201911144.a152820379.a_1538222063" label="Step1">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a1017730618.a201911144.a152820379.a_1538222063.a2089022316" mode="normal" value="Hello">
									</UiText>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a1017730618.a201911144.a152820379.a_1538222062" label="Step2">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a1017730618.a201911144.a152820379.a_1538222062.a436883153" mode="normal" value="World">
									</UiText>
								</UiStep>
							</UiWizard>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a1017730618.a201911144.a1472409059" layout="vertical">
								<UiWizardNavigator context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a1017730618.a201911144.a1472409059.a_1835777477" format="bordered">
								</UiWizardNavigator>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a1017730618.a201911144.a1505556201" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a942407306.a1017730618.a201911144.a1505556201.a_580071535" mode="normal" language="Html" value="Wizard(style=ContentOnly)&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step10 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step1&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;Hello&quot;)&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step11 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step2&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;World&quot;)&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(WizardExamplesMold));
DisplayFactory.register("WizardExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(WizardExamplesMold)));