import BaseDialogNotifier from "./BaseDialogNotifier"

export default class CollectionDialogNotifier extends BaseDialogNotifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("refreshSelectionCount").toSelf().execute((parameters) => this.element.refreshSelectionCount(parameters.v));
		this.pushLinked = true;
	};
}