import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiFile from "alexandria-ui-elements/src/displays/components/File";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiFileEditable from "alexandria-ui-elements/src/displays/components/FileEditable";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import FileExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import FileExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class FileExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new FileExamplesMoldNotifier(this);
		this.requester = new FileExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120022544" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120022544.a_944357153" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120022544.a_944357153.a386249799" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120022544.a_944357153.a1056077197" format="filled" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120022544.a_944357153.a1056077197.a_922840486" layout="vertical" width="-1px" height="600px">
								<UiFile context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120022544.a_944357153.a1056077197.a_922840486.a899204558" format="widgetDemo" width="100.0%" height="100.0%">
								</UiFile>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120022544.a_944357153.a1056077197.a_2030653501" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120022544.a_944357153.a1056077197.a_2030653501.a1781226973" mode="normal" language="Html" value="File(value=&quot;data/example.pdf&quot;) as Relative(width=100%, height=100%)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120022544.a311344519" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120022544.a311344519.a506490243" format="h6" mode="normal" value="Editable facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120022544.a311344519.a1031906581" format="filled" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120022544.a311344519.a1031906581.a_1893094275" layout="vertical" width="-1px" height="600px">
								<UiFileEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120022544.a311344519.a1031906581.a_1893094275.a702691054" format="widgetDemo" width="100.0%" height="100.0%" progress={true}>
								</UiFileEditable>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120022544.a311344519.a1031906581.a_896038469" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1120022544.a311344519.a1031906581.a_896038469.a1276591869" mode="normal" language="Html" value="File(value=&quot;data/example.pdf&quot;) as Relative(width=100%, height=100%) Editable(showDropZone=false, showProgress=true)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_932003933" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_932003933.a504845113" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_932003933.a504845113.a_1943126472" format="h6" mode="normal" value="Editable facet with drop zone">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_932003933.a504845113.a_986636734" format="filled" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_932003933.a504845113.a_986636734.a_123510244" layout="vertical" width="-1px" height="600px">
								<UiFileEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_932003933.a504845113.a_986636734.a_123510244.a1186235920" format="widgetDemo" width="100.0%" height="100.0%" dropZone={true} dropZoneLimit={1}>
								</UiFileEditable>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_932003933.a504845113.a_986636734.a_1461273443" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_932003933.a504845113.a_986636734.a_1461273443.a185150751" mode="normal" language="Html" value="File(value=&quot;data/example.pdf&quot;) as Relative(width=100%, height=100%) Editable(showDropZone=true)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_932003933.a_889461560" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_932003933.a_889461560.a_658065242" format="h6" mode="normal" value="Editable facet with drop zone and paste zone">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_932003933.a_889461560.a1918407495" format="filled" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_932003933.a_889461560.a1918407495.a_334314594" layout="vertical" width="-1px" height="600px">
								<UiFileEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_932003933.a_889461560.a1918407495.a_334314594.a_817732047" format="widgetDemo" width="100.0%" height="100.0%" dropZone={true} pasteZone={true} dropZoneLimit={1}>
								</UiFileEditable>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_932003933.a_889461560.a1918407495.a756804435" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_932003933.a_889461560.a1918407495.a756804435.a_612887360" mode="normal" language="Html" value="File(value=&quot;data/example.pdf&quot;) as Relative(width=100%, height=100%) Editable(showDropZone=true, showPasteZone=true)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_413781192" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_413781192.a_2133423421" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_413781192.a_2133423421.a_88027503" format="h6" mode="normal" value="Editable facet with drop zone and progress bar">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_413781192.a_2133423421.a_1549381896" format="filled" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_413781192.a_2133423421.a_1549381896.a456680777" layout="vertical" width="-1px" height="600px">
								<UiFileEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_413781192.a_2133423421.a_1549381896.a456680777.a_334187181" format="widgetDemo" width="100.0%" height="100.0%" dropZone={true} progress={true} dropZoneLimit={4}>
								</UiFileEditable>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_413781192.a_2133423421.a_1549381896.a_623498551" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_413781192.a_2133423421.a_1549381896.a_623498551.a_1704328478" mode="normal" language="Html" value="File(value=&quot;data/example.pdf&quot;) as Relative(width=100%, height=100%) Editable(showDropZone=true, showProgress=true, dropZoneLimit=4)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_413781192.a_1538991267" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_413781192.a_1538991267.a639643131" format="h6" mode="normal" value="Editable facet with paste zone">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_413781192.a_1538991267.a_557236029" format="filled" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_413781192.a_1538991267.a_557236029.a_484492149" layout="vertical" width="-1px" height="600px">
								<UiFileEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_413781192.a_1538991267.a_557236029.a_484492149.a_530700685" format="widgetDemo" width="100.0%" height="100.0%" pasteZone={true}>
								</UiFileEditable>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_413781192.a_1538991267.a_557236029.a_769288108" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_413781192.a_1538991267.a_557236029.a_769288108.a2086003714" mode="normal" language="Html" value="File(value=&quot;data/example.pdf&quot;) as Relative(width=100%, height=100%) Editable(showPasteZone=true)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(FileExamplesMold));
DisplayFactory.register("FileExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(FileExamplesMold)));