import Requester from "./Requester";

export default class BaseMultipleRequester extends Requester {
	constructor(element) {
		super(element);
	};
	add = () => {
	    if (this.addToHistory()) return;
	    this.pushService.send({ op: "add", s: "basemultiple", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	select = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ op: "select", s: "basemultiple", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	remove = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ op: "remove", s: "basemultiple", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
    didMount = () => {
	    this.pushService.send({ op: "didMount", s: "basemultiple", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
    };
}