import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiHeader from "alexandria-ui-elements/src/displays/components/Header";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiOpenSite from "alexandria-ui-elements/src/displays/components/OpenSite";
import UiList from "alexandria-ui-elements/src/displays/components/List";
import UiSelectorTabs from "alexandria-ui-elements/src/displays/components/SelectorTabs";
import UiMaterialIcon from "alexandria-ui-elements/src/displays/components/MaterialIcon";
import DisplaysWidgetListMold from "ui-elements/gen/displays/items/WidgetListMold";
import DisplaysWidgetMold from "ui-elements/gen/displays/templates/WidgetMold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import MobileDocsTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import MobileDocsTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class MobileDocsTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new MobileDocsTemplateNotifier(this);
		this.requester = new MobileDocsTemplateRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" style={{...this.props.style,...display}}>
				<UiHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_109394264" format="air" color="white" position="relative" width="-1px" height="100px" elevation={4}>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_109394264.a_1454543813" layout="horizontal center" spacing="24">
						<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_109394264.a_1454543813.a1299039224" width="80px" height="80px">
						</UiImage>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_109394264.a_1454543813.a542657441" format="h3" mode="normal" value="intino">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_109394264.a_1454543813.a2111068913" format="headerToolbar" layout="horizontal center" spacing="24">
							<UiOpenSite context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_109394264.a_1454543813.a2111068913.a_1160789249" title="home" target="self" mode="Link" size="Medium">
							</UiOpenSite>
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_109394264.a_1454543813.a2111068913.a1225464157" mode="normal" value="widgets">
							</UiText>
						</UiBlock>
					</UiBlock>
				</UiHeader>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1248039234" layout="vertical" autoSize={true}>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1248039234.a2063686240" layout="vertical flexible">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1248039234.a2063686240.a_446075936" format="airBottom h5" mode="normal">
						</UiText>
						<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1248039234.a2063686240.a_810845119" noItemsMessage="No widgets defined" pageSize={20} itemHeight={200} scrollingMark={true}>
						</UiList>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1248039234.a_1399781187" format="air" visible={false} layout="vertical">
						<DisplaysWidgetMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1248039234.a_1399781187.a759134045">
						</DisplaysWidgetMold>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1037404399" layout="vertical end">
					<UiSelectorTabs context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1037404399.a_312050649" multipleSelection={false}>
						<UiMaterialIcon context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1037404399.a_312050649.a_1795881001" name="dataOption" icon="Edit">
						</UiMaterialIcon>
						<UiMaterialIcon context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1037404399.a_312050649.a_405070890" name="catalogOption" icon="List">
						</UiMaterialIcon>
						<UiMaterialIcon context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1037404399.a_312050649.a883492004" name="operationOption" icon="PlayArrow">
						</UiMaterialIcon>
						<UiMaterialIcon context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1037404399.a_312050649.a1077493645" name="otherOption" icon="MoreHoriz">
						</UiMaterialIcon>
					</UiSelectorTabs>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(MobileDocsTemplate));
DisplayFactory.register("MobileDocsTemplate", withStyles(styles, { withTheme: true })(withSnackbar(MobileDocsTemplate)));