import ActionableNotifier from "./ActionableNotifier"

export default class AuthenticateNotifier extends ActionableNotifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("sign").toSelf().execute(() => this.element.sign());
		this.pushLinked = true;
	};
}