import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSorting from "alexandria-ui-elements/src/displays/components/Sorting";
import UiList from "alexandria-ui-elements/src/displays/components/List";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiSelectorComboBox from "alexandria-ui-elements/src/displays/components/SelectorComboBox";
import DisplaysSorting1Mold from "ui-elements/gen/displays/items/Sorting1Mold";
import DisplaysSorting2Mold from "ui-elements/gen/displays/items/Sorting2Mold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import SortingExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import SortingExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class SortingExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new SortingExamplesMoldNotifier(this);
		this.requester = new SortingExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2044497127" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2044497127.a_1012013760" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2044497127.a_1012013760.a_980384753" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2044497127.a_1012013760.a_1760868966" format="filledNoAir" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2044497127.a_1012013760.a_1760868966.a_1551817097" format="air" layout="horizontal">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2044497127.a_1012013760.a_1760868966.a_1551817097.a1030192764" format="airRight description subtitle2" mode="normal" value="mostrar primero">
								</UiText>
								<UiSorting context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2044497127.a_1012013760.a_1760868966.a_1551817097.a636866593" label="female population">
								</UiSorting>
							</UiBlock>
							<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2044497127.a_1012013760.a_1760868966.a_1501457438" pageSize={20} itemHeight={60} scrollingMark={true}>
							</UiList>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2044497127.a_1012013760.a_1034852551" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2044497127.a_1012013760.a_1034852551.a_1558583768" mode="normal" language="Html" value="Block(layout=Horizontal)
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;mostrar primero&quot;)
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Sorting(collections=list) gender1 as Labeled(&quot;female population&quot;)
							List(itemClass=&quot;io.intino.alexandria.ui.documentation.Person&quot;) list&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item(height=60px,relativeWidth=30%) sortingMold&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text firstName&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal, spacing=DP16)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(format=description) gender&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(format=description) age as Labeled(&quot;age&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2044497127.a1055710561" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2044497127.a1055710561.a802707023" format="h6" mode="normal" value="Sortings inside Selector">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2044497127.a1055710561.a_1857861990" format="filledNoAir" layout="vertical" spacing="8">
							<UiSelectorComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2044497127.a1055710561.a_1857861990.a_2094353876" format="air" multipleSelection={true} maxMenuHeight={300}>
								<UiSorting context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2044497127.a1055710561.a_1857861990.a_2094353876.a1446940294" name="youthest" label="youthest population">
								</UiSorting>
								<UiSorting context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2044497127.a1055710561.a_1857861990.a_2094353876.a1249351538" name="oldest" label="oldest population">
								</UiSorting>
								<UiSorting context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2044497127.a1055710561.a_1857861990.a_2094353876.a985488575" name="female" label="female population">
								</UiSorting>
								<UiSorting context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2044497127.a1055710561.a_1857861990.a_2094353876.a_164132800" name="male" label="male population">
								</UiSorting>
							</UiSelectorComboBox>
							<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2044497127.a1055710561.a_1857861990.a145690663" pageSize={20} itemHeight={60} scrollingMark={true}>
							</UiList>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2044497127.a1055710561.a_565921242" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2044497127.a1055710561.a_565921242.a366148101" mode="normal" language="Html" value="Selector as ComboBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;multipleSelection=true&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Sorting(collections=list) as Option(&quot;youthest&quot;) Labeled(&quot;youthest population&quot;)
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Sorting(collections=list) as Option(&quot;oldest&quot;) Labeled(&quot;oldest population&quot;)
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Sorting(collections=list) as Option(&quot;female&quot;) Labeled(&quot;female population&quot;)
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Sorting(collections=list) as Option(&quot;male&quot;) Labeled(&quot;male population&quot;)
							List(itemClass=&quot;io.intino.alexandria.ui.documentation.Person&quot;) list&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item(height=60px,relativeWidth=30%) sortingMold&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text firstName&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal, spacing=DP16)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(format=description) gender&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(format=description) age as Labeled(&quot;age&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(SortingExamplesMold));
DisplayFactory.register("SortingExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(SortingExamplesMold)));