import BaseFileNotifier from "./BaseFileNotifier"

export default class FileEditableNotifier extends BaseFileNotifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("refreshReadonly").toSelf().execute((parameters) => this.element.refreshReadonly(parameters.v));
		this.when("refreshAllowedTypes").toSelf().execute((parameters) => this.element.refreshAllowedTypes(parameters.v));
		this.when("refreshFocused").toSelf().execute((parameters) => this.element.refreshFocused(parameters.v));
		this.when("refreshMaxSize").toSelf().execute((parameters) => this.element.refreshMaxSize(parameters.v));
		this.pushLinked = true;
	};
}