import ActionableNotifier from "./ActionableNotifier"

export default class UploadNotifier extends ActionableNotifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("openDialog").toSelf().execute(() => this.element.openDialog());
		this.when("refreshAllowedTypes").toSelf().execute((parameters) => this.element.refreshAllowedTypes(parameters.v));
		this.pushLinked = true;
	};
}