import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import WidgetSummaryMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import WidgetSummaryMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class WidgetSummaryMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new WidgetSummaryMoldNotifier(this);
		this.requester = new WidgetSummaryMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical flexible" width="100.0%" height={this.fixHeight != null ? this.fixHeight("100.0%") : "100.0%"} style={{...this.props.style,...display}}>
				<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1166003094" title="" target="self" mode="Link" size="Large" format="h6">
				</UiAction>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555127582" layout="flexible">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555127582.a_180234160" mode="normal">
					</UiText>
				</UiBlock>
				<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1377648670" format="body2" backgroundColor="#679164" multiple={{instances:"facets",arrangement:"Horizontal",noItemsMessage:"",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}} mode="normal" highlighted={{text:"white",background:"#679164"}}>
				</UiMultiple>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(WidgetSummaryMold));
DisplayFactory.register("WidgetSummaryMold", withStyles(styles, { withTheme: true })(withSnackbar(WidgetSummaryMold)));