import Requester from "./Requester";

export default class WizardNavigatorRequester extends Requester {
	constructor(element) {
		super(element);
	};
	back = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "back", s: "wizardnavigator", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	select = (value) => {
		if (this.addToHistory(value)) return;
		this.pushService.send({ app: this.element.context, op: "select", s: "wizardnavigator", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	next = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "next", s: "wizardnavigator", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	finish = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "finish", s: "wizardnavigator", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	didMount = () => {
		this.pushService.send({ op: "didMount", s: "wizardnavigator", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
}