import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiUpload from "alexandria-ui-elements/src/displays/components/Upload";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import UploadExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import UploadExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class UploadExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new UploadExamplesMoldNotifier(this);
		this.requester = new UploadExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a359043777" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a359043777.a142377503" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a359043777.a142377503.a_631451572" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a359043777.a142377503.a1186684107" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiUpload context={this._context.bind(this)} owner={this._owner.bind(this)} id="a359043777.a142377503.a1186684107.a_58308222" title="upload..." target="self" mode="Link" size="Medium" progress={false} allowedTypes={[""]}>
							</UiUpload>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a359043777.a142377503.a_1923564931" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a359043777.a142377503.a_1923564931.a_1575982715" mode="normal" language="Html" value="Button(title=&quot;upload...&quot;) as Upload">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a359043777.a_1015905515" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a359043777.a_1015905515.a1673480134" format="h6" mode="normal" value="No facets with multiple selection">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a359043777.a_1015905515.a760050895" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiUpload context={this._context.bind(this)} owner={this._owner.bind(this)} id="a359043777.a_1015905515.a760050895.a70774498" title="upload..." target="self" mode="MaterialIconButton" icon="Clear" size="Medium" multipleSelection={true} progress={false} allowedTypes={[""]}>
							</UiUpload>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a359043777.a_1015905515.a_1288683885" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a359043777.a_1015905515.a_1288683885.a1504524998" mode="normal" language="Html" value="Button(title=&quot;upload...&quot;) as Upload(multipleSelection=true)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1470521408" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1470521408.a_1812045623" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1470521408.a_1812045623.a1132122907" format="h6" mode="normal" value="No facets with multiple selection and progress">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1470521408.a_1812045623.a1669947577" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiUpload context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1470521408.a_1812045623.a1669947577.a_1597094141" title="upload..." target="self" mode="Link" size="Medium" multipleSelection={true} progress={true} allowedTypes={[""]}>
							</UiUpload>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1470521408.a_1812045623.a1061214055" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1470521408.a_1812045623.a1061214055.a757617785" mode="normal" language="Html" value="Link(title=&quot;upload...&quot;) as Upload(multipleSelection=true, showProgress=true)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(UploadExamplesMold));
DisplayFactory.register("UploadExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(UploadExamplesMold)));