import Requester from "./Requester";

export default class HtmlViewerRequester extends Requester {
	constructor(element) {
		super(element);
	};
	execute = (value) => {
		if (this.addToHistory(value)) return;
		this.pushService.send({ app: this.element.context, op: "execute", s: "htmlviewer", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(JSON.stringify(value))}, this.element.ownerUnit());
	};
	didMount = () => {
		this.pushService.send({ op: "didMount", s: "htmlviewer", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
}