import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import UiMultipleImage from "alexandria-ui-elements/src/displays/components/MultipleImage";
import DisplaysMultiple2Template from "ui-elements/gen/displays/templates/Multiple2Template";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import MultipleExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import MultipleExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class MultipleExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new MultipleExamplesMoldNotifier(this);
		this.requester = new MultipleExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a_2054420581" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a_2054420581.a_518700325" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a_2054420581.a1709711481" format="filled" layout="vertical" spacing="8">
							<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a_2054420581.a1709711481.a_1558470940" multiple={{instances:"multiple1",arrangement:"Vertical",noItemsMessage:"No elements found",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}} mode="normal">
							</UiMultiple>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a_2054420581.a1709711481.a_1815087418" layout="vertical">
								<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a_2054420581.a1709711481.a_1815087418.a1475925300" multiple={{instances:"multiple1Code",arrangement:"Vertical",noItemsMessage:"",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}} mode="normal" value="Text as Multiple<br/>">
								</UiMultiple>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a225946076" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a225946076.a647063151" format="h6" mode="normal" value="Editable facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a225946076.a326789335" format="filled" layout="vertical" spacing="8">
							<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a225946076.a326789335.a_2064029564" multiple={{instances:"multiple2",arrangement:"Vertical",noItemsMessage:"No elements found",spacing:0,editable:true,wrap:true,collapsed:false,count:{min:0,max:-1}}} mode="normal">
							</UiMultiple>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a225946076.a326789335.a_1765363879" layout="vertical">
								<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a225946076.a326789335.a_1765363879.a479776468" multiple={{instances:"multiple2Code",arrangement:"Vertical",noItemsMessage:"",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}} mode="normal" value="Text as Multiple Editable<br/>">
								</UiMultiple>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a46241118" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a46241118.a487424750" format="h6" mode="normal" value="No facets with collapsed">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a46241118.a_172385608" format="filled" layout="vertical" spacing="8">
							<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a46241118.a_172385608.a_641815716" multiple={{instances:"multiple3",arrangement:"Vertical",noItemsMessage:"",spacing:0,editable:false,wrap:true,collapsed:true,count:{min:0,max:-1}}}>
							</UiMultiple>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a46241118.a_172385608.a_1768644077" layout="vertical">
								<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a46241118.a_172385608.a_1768644077.a_516372364" multiple={{instances:"multiple3Code",arrangement:"Vertical",noItemsMessage:"",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}} mode="normal" value="TemplateStamp(template=multiple2Template) multiple2 as Multiple(collapsed=true)</br>
								Template multiple2Template
									Text field1 as Editable">
								</UiMultiple>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a2018237540" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a2018237540.a_1437415881" format="h6" mode="normal" value="No facets with Image">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a2018237540.a293217324" format="filled" layout="vertical" spacing="8">
							<UiMultipleImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a2018237540.a293217324.a633014470" multiple={{instances:"multiple4",arrangement:"Vertical",noItemsMessage:"No elements found",spacing:0,editable:true,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
							</UiMultipleImage>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a2018237540.a293217324.a28425995" layout="vertical">
								<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1791632588.a2018237540.a293217324.a28425995.a1194098198" multiple={{instances:"multiple4Code",arrangement:"Vertical",noItemsMessage:"",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}} mode="normal" value="Image as Multiple<br/>">
								</UiMultiple>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(MultipleExamplesMold));
DisplayFactory.register("MultipleExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(MultipleExamplesMold)));