import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiEventline from "alexandria-ui-elements/src/displays/components/Eventline";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import EventlineExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import EventlineExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class EventlineExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new EventlineExamplesMoldNotifier(this);
		this.requester = new EventlineExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2096232912" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2096232912.a_1397964917" format="extraHeight" layout="vertical" width="100.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2096232912.a_1397964917.a_1905780882" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2096232912.a_1397964917.a1542358713" format="air filledNoAirExtraLarge" layout="vertical">
							<UiEventline context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2096232912.a_1397964917.a1542358713.a_1954611799" arrangement="Horizontal"
							 toolbarArrangement="Right">
							</UiEventline>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2096232912.a_1397964917.a1542358713.a626858603" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2096232912.a_1397964917.a1542358713.a626858603.a2102655337" mode="normal" language="Html" value="Eventline">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2096232912.a_1397964916" layout="vertical" width="100.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2096232912.a_1397964916.a_1398981405" format="h6" mode="normal" value="No facets (Vertical arrangement)">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2096232912.a_1397964916.a_265095719" format="air filledNoAirLarge" layout="vertical">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2096232912.a_1397964916.a_265095719.a1633244619" layout="vertical" width="-1px" height="400px">
								<UiEventline context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2096232912.a_1397964916.a_265095719.a1633244619.a252342104" arrangement="Vertical"
								 toolbarArrangement="Right">
								</UiEventline>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2096232912.a_1397964916.a_265095719.a_1875089517" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2096232912.a_1397964916.a_265095719.a_1875089517.a_1077284694" mode="normal" language="Html" value="Eventline(arrangement=Vertical)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(EventlineExamplesMold));
DisplayFactory.register("EventlineExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(EventlineExamplesMold)));